/*
 * Decompiled with CFR 0.152.
 */
package cn.cenxt.task.constants;

import cn.cenxt.task.enums.ExecResultEnum;
import cn.cenxt.task.enums.TaskStatusEnum;

public class Constants {
    public static final int MIN_INTERVAL = 500;
    public static final int DEFAULT_INTERVAL = 3000;
    public static final int DEFAULT_FETCH_SIZE = 3;
    public static final int DEFAULT_THREAD_SIZE = 3;
    public static final String SESSION_USERNAME = "CENXT_TASK_USERNAME";
    public static final String SESSION_ROLE = "CENXT_TASK_USER_ROLE";
    public static String TABLE_NAME_TASK = "cenxt_task";
    public static String TABLE_NAME_EXEC_HISTORY = "cenxt_exec_history";

    public static String SQL_CREATE_TASK_TABLE() {
        return "CREATE TABLE IF NOT EXISTS `" + TABLE_NAME_TASK + "` (\n  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '\u7f16\u53f7',\n  `name` varchar(100) NOT NULL COMMENT '\u4efb\u52a1\u540d\u79f0',\n  `description` varchar(256) NOT NULL COMMENT '\u63cf\u8ff0',\n  `enabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u542f\u7528\u72b6\u6001',\n  `flag` tinyint(2) NOT NULL DEFAULT '0' COMMENT '\u6267\u884c\u72b6\u6001\uff1a0\u5f85\u6267\u884c 1\u6267\u884c\u4e2d 2\u6267\u884c\u5931\u8d25',\n  `cron_str` varchar(256) NOT NULL COMMENT '\u65f6\u95f4\u8868\u8fbe\u5f0f',\n  `expire` int(11) NOT NULL COMMENT '\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u5206\u949f\uff0c0\u4e3a\u4e0d\u8d85\u65f6',\n  `retry_times` int(11) NOT NULL COMMENT '\u91cd\u8bd5\u6b21\u6570',\n  `params` varchar(4096) NOT NULL DEFAULT '' COMMENT '\u53c2\u6570',\n  `exec_time` timestamp NULL DEFAULT NULL COMMENT '\u6267\u884c\u65f6\u95f4',\n  `exec_ip` varchar(50) DEFAULT NULL COMMENT '\u6267\u884c\u673a\u5668IP',\n  `next_time` timestamp NOT NULL COMMENT '\u4e0b\u6b21\u6267\u884c\u65f6\u95f4',\n  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u521b\u5efa\u65f6\u95f4',\n  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u66f4\u65b0\u65f6\u95f4',\n  `creator` varchar(50) NOT NULL COMMENT '\u521b\u5efa\u4eba',\n  `updator` varchar(50) DEFAULT NULL COMMENT '\u66f4\u65b0\u4eba',\n  PRIMARY KEY (`id`),\n  KEY `name` (`name`),\n  KEY `create_time` (`create_time`),\n  KEY `update_time` (`update_time`),\n  KEY `exec_time` (`exec_time`),\n  KEY `next_time` (`next_time`),\n  KEY `expire` (`expire`),\n  KEY `exec_ip` (`exec_ip`)\n) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='\u4efb\u52a1\u8868';";
    }

    public static final String SQL_CREATE_EXEC_HISTORY_TABLE() {
        return "CREATE TABLE IF NOT EXISTS `" + TABLE_NAME_EXEC_HISTORY + "` (\n  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '\u7f16\u53f7',\n  `task_id` bigint(20) NOT NULL COMMENT '\u4efb\u52a1\u7f16\u53f7',\n  `exec_id` varchar(50) NOT NULL DEFAULT '' COMMENT '\u6267\u884c\u7f16\u53f7',\n  `exec_ip` varchar(50) NOT NULL DEFAULT '' COMMENT '\u6267\u884c\u673a\u5668IP',\n  `exec_time` timestamp NOT NULL COMMENT '\u6267\u884c\u65f6\u95f4',\n  `finish_time` timestamp NULL DEFAULT NULL COMMENT '\u7ed3\u675f\u65f6\u95f4',\n  `cost` double NOT NULL DEFAULT '0' COMMENT '\u6267\u884c\u8017\u65f6\uff0c\u5355\u4f4dms',\n  `exec_result` tinyint(2) NOT NULL COMMENT '\u6267\u884c\u7ed3\u679c\uff1a0\u5f85\u6267\u884c 1\u6267\u884c\u4e2d 2\u6267\u884c\u6210\u529f 3\u91cd\u8bd5\u4e2d 4\u91cd\u8bd5\u6210\u529f 5\u6267\u884c\u5931\u8d25 6\u8d85\u65f6\u4e2d\u65ad ',\n  `retry_times` int(11) DEFAULT '0' COMMENT '\u91cd\u8bd5\u6b21\u6570',\n  `success_count` bigint(20) DEFAULT '0' COMMENT '\u6210\u529f\u8bb0\u5f55\u6570',\n  `fail_count` bigint(20) DEFAULT '0' COMMENT '\u5931\u8d25\u8bb0\u5f55\u6570',\n  `exec_message` varchar(10240) DEFAULT '' COMMENT '\u6267\u884c\u4fe1\u606f',\n  PRIMARY KEY (`id`),\n  UNIQUE KEY `exec_id` (`exec_id`),\n  KEY `exec_time` (`exec_time`),\n  KEY `finish_time` (`finish_time`),\n  KEY `task_id` (`task_id`),\n  KEY `cost` (`cost`),\n  KEY `exec_ip` (`exec_ip`),\n  KEY `exec_result` (`exec_result`)\n) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='\u6267\u884c\u8bb0\u5f55\u8868';";
    }

    public static final String SQL_QUERY_WAITE_EXEC_TASK_LIST() {
        return "SELECT * FROM " + TABLE_NAME_TASK + " WHERE \n##\u4efb\u52a1\u662f\u542f\u7528\u72b6\u6001\nenabled=1 \nAND (\n\t##\u4efb\u52a1\u5f85\u6267\u884c\u4e14\u4e0b\u6b21\u6267\u884c\u65f6\u95f4\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\n\t(flag=" + TaskStatusEnum.WAITING.getStatus() + " AND next_time<NOW()) \n\t##\u4efb\u52a1\u4e3a\u6267\u884c\u4e2d\uff0c\u4e14\u4efb\u52a1\u5df2\u8d85\u65f6\u6267\u884c\n\tOR (flag=" + TaskStatusEnum.RUNNING.getStatus() + " AND exec_time<DATE_SUB(NOW(),interval `expire`+1 MINUTE))\n\tOR (\n\t\t##\u6267\u884c\u5931\u8d25\n\t\tflag=" + TaskStatusEnum.FAIL.getStatus() + " \n\t\tAND (\n\t\t\t##\u5982\u679c\u4e0a\u6b21\u6267\u884c\u673a\u5668\u4e3a\u5f53\u524d\u673a\u5668\uff0c\u6267\u884c\u65f6\u95f4\u5ef6\u540e1\u5206\u949f\n\t\t\t(exec_ip=? AND next_time<DATE_SUB(NOW(),interval 1 MINUTE))\n\t\t\t##\u5982\u679c\u4e0a\u6b21\u6267\u884c\u673a\u5668\u4e0d\u662f\u5f53\u524d\uff0c\u5230\u65f6\u95f4\u81ea\u52a8\u6267\u884c\n\t\t\tOR (exec_ip<>? AND next_time<NOW())\n\t\t)\n\t)\n) LIMIT ?";
    }

    public static final String SQL_QUERY_LOCK_TASK() {
        return "UPDATE " + TABLE_NAME_TASK + " SET flag=" + TaskStatusEnum.RUNNING.getStatus() + ",exec_time=NOW(),exec_ip=? WHERE id=? AND enabled=1 AND (exec_time=? OR exec_time IS NULL)";
    }

    public static final String SQL_RELEASE_TASK() {
        return "UPDATE " + TABLE_NAME_TASK + " SET flag=?,next_time=? WHERE id=? AND flag=" + TaskStatusEnum.RUNNING.getStatus();
    }

    public static final String SQL_FAIL_AND_RELEASE_TASK() {
        return "UPDATE " + TABLE_NAME_TASK + " SET enabled=0,flag=" + TaskStatusEnum.FAIL.getStatus() + ",update_time=now(),updator='system' WHERE id=? AND enabled=1 ";
    }

    public static final String SQL_INSERT_EXEC_HISTORY() {
        return "INSERT INTO " + TABLE_NAME_EXEC_HISTORY + " (`task_id`, `exec_id`, `exec_ip`, `exec_time`, `finish_time`, `cost`, `exec_result`, `retry_times`, `success_count`, `fail_count`, `exec_message`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    public static final String SQL_UPDATE_EXEC_HISTORY() {
        return "UPDATE " + TABLE_NAME_EXEC_HISTORY + " SET finish_time=?, cost=?,exec_result=?, retry_times=?, success_count=?, fail_count=?, exec_message=? WHERE exec_id=?";
    }

    public static final String SQL_INSERT_TASK() {
        return "INSERT INTO `" + TABLE_NAME_TASK + "` (`name`, `description`, `cron_str`, `expire`, `retry_times`, `params`, `next_time`, `create_time`, `creator`) \nVALUES (?, ?, ?, ?, ?, ?, ?, now(), ?);";
    }

    public static final String SQL_UPDATE_TASK() {
        return "UPDATE `" + TABLE_NAME_TASK + "` SET `name`=?, `description`=?, `cron_str`=?, `expire`=?, `retry_times`=?, `params`=?, `next_time`=?,`updator`=?, `update_time`=now() WHERE  `id`=?";
    }

    public static final String SQL_UPDATE_TASK_ENABLE() {
        return "UPDATE `" + TABLE_NAME_TASK + "` SET `enabled`=?,`updator`=?, `update_time`=now() WHERE  `id`=?";
    }

    public static final String SQL_DELETE_TASK() {
        return "DELETE FROM `" + TABLE_NAME_TASK + "` WHERE  `id`=?";
    }

    public static final String SQL_QUERY_ALL_TASK_LIST() {
        return "SELECT * FROM " + TABLE_NAME_TASK + " order by update_time desc";
    }

    public static final String SQL_QUERY_ALL_TASK_LIST_BY_USER() {
        return "SELECT * FROM " + TABLE_NAME_TASK + " where creator=? order by update_time desc";
    }

    public static final String SQL_QUERY_EXEC_HISTORY_LIST() {
        return "SELECT * FROM " + TABLE_NAME_EXEC_HISTORY + " WHERE task_id=? order by exec_time DESC LIMIT ?";
    }

    public static final String SQL_QUERY_EXEC_HISTORY_BY_EXEC_ID() {
        return "SELECT * FROM " + TABLE_NAME_EXEC_HISTORY + " WHERE exec_id=?";
    }

    public static final String SQL_QUERY_ERROR_EXEC_HISTORY_LIST() {
        return "SELECT * FROM " + TABLE_NAME_EXEC_HISTORY + " WHERE task_id=? AND exec_result<>" + ExecResultEnum.SUCCESS.getResult() + " order by exec_time DESC LIMIT ?";
    }

    public static final String SQL_DELETE_EXEC_HISTORY() {
        return "DELETE FROM " + TABLE_NAME_EXEC_HISTORY + " WHERE exec_time<? LIMIT ?";
    }
}

