/*
 * Decompiled with CFR 0.152.
 */
package cn.cenxt.task.configuration;

import cn.cenxt.task.filter.CenxtTaskFilter;
import cn.cenxt.task.service.CenxtSecurityService;
import cn.cenxt.task.service.DefaultCenxtSecurityService;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.annotation.Order;

@ConditionalOnWebApplication
@ConditionalOnProperty(name={"cenxt.task.view.enabled"}, havingValue="true", matchIfMissing=true)
@ComponentScan(basePackages={"cn.cenxt.task.controller"})
public class CenxtTaskViewConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CenxtSecurityService.class})
    public CenxtSecurityService cenxtSecurityService() {
        return new DefaultCenxtSecurityService();
    }

    @Bean
    @Order
    public FilterRegistrationBean cenxtTaskFilter(CenxtSecurityService cenxtSecurityService) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new CenxtTaskFilter(cenxtSecurityService), new ServletRegistrationBean[0]);
        filterRegistrationBean.addUrlPatterns(new String[]{"/cenxt-task-view/*"});
        return filterRegistrationBean;
    }
}

