/*
 * Decompiled with CFR 0.152.
 */
package cn.cenxt.task.configuration;

import cn.cenxt.task.listeners.CenxtTaskListener;
import cn.cenxt.task.listeners.DefaultTaskListener;
import cn.cenxt.task.scheduler.CenxtTaskScheduler;
import cn.cenxt.task.service.CenxtTaskService;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.jdbc.core.JdbcTemplate;

@Import(value={CenxtTaskScheduler.class})
@ConditionalOnProperty(name={"cenxt.task.enabled"}, havingValue="true", matchIfMissing=true)
@ComponentScan(basePackages={"cn.cenxt.task.jobs"})
@AutoConfigureAfter(value={JdbcTemplateAutoConfiguration.class})
public class CenxtTaskConfiguration {
    @ConditionalOnMissingBean(value={CenxtTaskListener.class})
    @Bean
    public CenxtTaskListener taskListener() {
        return new DefaultTaskListener();
    }

    @Bean
    @ConditionalOnMissingBean(value={CenxtTaskService.class})
    public CenxtTaskService cenxtTaskService(JdbcTemplate jdbcTemplate) {
        return new CenxtTaskService(jdbcTemplate);
    }
}

