/*
 * Decompiled with CFR 0.152.
 */
package cn.cenxt.task.service;

import cn.cenxt.task.constants.Constants;
import cn.cenxt.task.enums.ExecResultEnum;
import cn.cenxt.task.enums.TaskStatusEnum;
import cn.cenxt.task.mapper.ExecHistoryMapper;
import cn.cenxt.task.mapper.TaskRowMapper;
import cn.cenxt.task.model.ExecHistory;
import cn.cenxt.task.model.Task;
import cn.cenxt.task.utils.CronAnalysisUtil;
import cn.cenxt.task.utils.IpUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class CenxtTaskService {
    private static final Logger logger = LoggerFactory.getLogger(CenxtTaskService.class);
    private JdbcTemplate jdbcTemplate;

    public CenxtTaskService() {
    }

    public CenxtTaskService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void initTable() {
        logger.info("begin init table");
        logger.info("CREATE TABLE IF NOT EXISTS `cenxt_task` (\n  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '\u7f16\u53f7',\n  `name` varchar(100) NOT NULL COMMENT '\u4efb\u52a1\u540d\u79f0',\n  `description` varchar(256) NOT NULL COMMENT '\u63cf\u8ff0',\n  `enabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u542f\u7528\u72b6\u6001',\n  `flag` tinyint(2) NOT NULL DEFAULT '0' COMMENT '\u6267\u884c\u72b6\u6001\uff1a0\u5f85\u6267\u884c 1\u6267\u884c\u4e2d 2\u6267\u884c\u5931\u8d25',\n  `cron_str` varchar(256) NOT NULL COMMENT '\u65f6\u95f4\u8868\u8fbe\u5f0f',\n  `expire` int(11) NOT NULL COMMENT '\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u5206\u949f\uff0c0\u4e3a\u4e0d\u8d85\u65f6',\n  `retry_times` int(11) NOT NULL COMMENT '\u91cd\u8bd5\u6b21\u6570',\n  `params` varchar(4096) NOT NULL DEFAULT '' COMMENT '\u53c2\u6570',\n  `exec_time` timestamp NULL DEFAULT NULL COMMENT '\u6267\u884c\u65f6\u95f4',\n  `exec_ip` varchar(50) DEFAULT NULL COMMENT '\u6267\u884c\u673a\u5668IP',\n  `next_time` timestamp NOT NULL COMMENT '\u4e0b\u6b21\u6267\u884c\u65f6\u95f4',\n  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u521b\u5efa\u65f6\u95f4',\n  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u66f4\u65b0\u65f6\u95f4',\n  `creator` varchar(50) NOT NULL COMMENT '\u521b\u5efa\u4eba',\n  `updator` varchar(50) DEFAULT NULL COMMENT '\u66f4\u65b0\u4eba',\n  PRIMARY KEY (`id`),\n  KEY `name` (`name`),\n  KEY `create_time` (`create_time`),\n  KEY `update_time` (`update_time`),\n  KEY `exec_time` (`exec_time`),\n  KEY `next_time` (`next_time`),\n  KEY `expire` (`expire`),\n  KEY `exec_ip` (`exec_ip`)\n) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='\u4efb\u52a1\u8868';");
        if (!this.checkTableExist("cenxt_task")) {
            this.jdbcTemplate.update("CREATE TABLE IF NOT EXISTS `cenxt_task` (\n  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '\u7f16\u53f7',\n  `name` varchar(100) NOT NULL COMMENT '\u4efb\u52a1\u540d\u79f0',\n  `description` varchar(256) NOT NULL COMMENT '\u63cf\u8ff0',\n  `enabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u542f\u7528\u72b6\u6001',\n  `flag` tinyint(2) NOT NULL DEFAULT '0' COMMENT '\u6267\u884c\u72b6\u6001\uff1a0\u5f85\u6267\u884c 1\u6267\u884c\u4e2d 2\u6267\u884c\u5931\u8d25',\n  `cron_str` varchar(256) NOT NULL COMMENT '\u65f6\u95f4\u8868\u8fbe\u5f0f',\n  `expire` int(11) NOT NULL COMMENT '\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u5206\u949f\uff0c0\u4e3a\u4e0d\u8d85\u65f6',\n  `retry_times` int(11) NOT NULL COMMENT '\u91cd\u8bd5\u6b21\u6570',\n  `params` varchar(4096) NOT NULL DEFAULT '' COMMENT '\u53c2\u6570',\n  `exec_time` timestamp NULL DEFAULT NULL COMMENT '\u6267\u884c\u65f6\u95f4',\n  `exec_ip` varchar(50) DEFAULT NULL COMMENT '\u6267\u884c\u673a\u5668IP',\n  `next_time` timestamp NOT NULL COMMENT '\u4e0b\u6b21\u6267\u884c\u65f6\u95f4',\n  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u521b\u5efa\u65f6\u95f4',\n  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u66f4\u65b0\u65f6\u95f4',\n  `creator` varchar(50) NOT NULL COMMENT '\u521b\u5efa\u4eba',\n  `updator` varchar(50) DEFAULT NULL COMMENT '\u66f4\u65b0\u4eba',\n  PRIMARY KEY (`id`),\n  KEY `name` (`name`),\n  KEY `create_time` (`create_time`),\n  KEY `update_time` (`update_time`),\n  KEY `exec_time` (`exec_time`),\n  KEY `next_time` (`next_time`),\n  KEY `expire` (`expire`),\n  KEY `exec_ip` (`exec_ip`)\n) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='\u4efb\u52a1\u8868';");
        }
        logger.info("CREATE TABLE IF NOT EXISTS `cenxt_exec_history` (\n  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '\u7f16\u53f7',\n  `task_id` bigint(20) NOT NULL COMMENT '\u4efb\u52a1\u7f16\u53f7',\n  `exec_id` varchar(50) NOT NULL DEFAULT '' COMMENT '\u6267\u884c\u7f16\u53f7',\n  `exec_ip` varchar(50) NOT NULL DEFAULT '' COMMENT '\u6267\u884c\u673a\u5668IP',\n  `exec_time` timestamp NOT NULL COMMENT '\u6267\u884c\u65f6\u95f4',\n  `finish_time` timestamp NULL DEFAULT NULL COMMENT '\u7ed3\u675f\u65f6\u95f4',\n  `cost` double NOT NULL DEFAULT '0' COMMENT '\u6267\u884c\u8017\u65f6\uff0c\u5355\u4f4dms',\n  `exec_result` tinyint(2) NOT NULL COMMENT '\u6267\u884c\u7ed3\u679c\uff1a0\u5f85\u6267\u884c 1\u6267\u884c\u4e2d 2\u6267\u884c\u6210\u529f 3\u91cd\u8bd5\u4e2d 4\u91cd\u8bd5\u6210\u529f 5\u6267\u884c\u5931\u8d25 6\u8d85\u65f6\u4e2d\u65ad ',\n  `retry_times` int(11) DEFAULT '0' COMMENT '\u91cd\u8bd5\u6b21\u6570',\n  `success_count` bigint(20) DEFAULT '0' COMMENT '\u6210\u529f\u8bb0\u5f55\u6570',\n  `fail_count` bigint(20) DEFAULT '0' COMMENT '\u5931\u8d25\u8bb0\u5f55\u6570',\n  `exec_message` varchar(10240) DEFAULT '' COMMENT '\u6267\u884c\u4fe1\u606f',\n  PRIMARY KEY (`id`),\n  UNIQUE KEY `exec_id` (`exec_id`),\n  KEY `exec_time` (`exec_time`),\n  KEY `finish_time` (`finish_time`),\n  KEY `task_id` (`task_id`),\n  KEY `cost` (`cost`),\n  KEY `exec_ip` (`exec_ip`),\n  KEY `exec_result` (`exec_result`)\n) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='\u6267\u884c\u8bb0\u5f55\u8868';");
        if (!this.checkTableExist("cenxt_exec_history")) {
            this.jdbcTemplate.update("CREATE TABLE IF NOT EXISTS `cenxt_exec_history` (\n  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '\u7f16\u53f7',\n  `task_id` bigint(20) NOT NULL COMMENT '\u4efb\u52a1\u7f16\u53f7',\n  `exec_id` varchar(50) NOT NULL DEFAULT '' COMMENT '\u6267\u884c\u7f16\u53f7',\n  `exec_ip` varchar(50) NOT NULL DEFAULT '' COMMENT '\u6267\u884c\u673a\u5668IP',\n  `exec_time` timestamp NOT NULL COMMENT '\u6267\u884c\u65f6\u95f4',\n  `finish_time` timestamp NULL DEFAULT NULL COMMENT '\u7ed3\u675f\u65f6\u95f4',\n  `cost` double NOT NULL DEFAULT '0' COMMENT '\u6267\u884c\u8017\u65f6\uff0c\u5355\u4f4dms',\n  `exec_result` tinyint(2) NOT NULL COMMENT '\u6267\u884c\u7ed3\u679c\uff1a0\u5f85\u6267\u884c 1\u6267\u884c\u4e2d 2\u6267\u884c\u6210\u529f 3\u91cd\u8bd5\u4e2d 4\u91cd\u8bd5\u6210\u529f 5\u6267\u884c\u5931\u8d25 6\u8d85\u65f6\u4e2d\u65ad ',\n  `retry_times` int(11) DEFAULT '0' COMMENT '\u91cd\u8bd5\u6b21\u6570',\n  `success_count` bigint(20) DEFAULT '0' COMMENT '\u6210\u529f\u8bb0\u5f55\u6570',\n  `fail_count` bigint(20) DEFAULT '0' COMMENT '\u5931\u8d25\u8bb0\u5f55\u6570',\n  `exec_message` varchar(10240) DEFAULT '' COMMENT '\u6267\u884c\u4fe1\u606f',\n  PRIMARY KEY (`id`),\n  UNIQUE KEY `exec_id` (`exec_id`),\n  KEY `exec_time` (`exec_time`),\n  KEY `finish_time` (`finish_time`),\n  KEY `task_id` (`task_id`),\n  KEY `cost` (`cost`),\n  KEY `exec_ip` (`exec_ip`),\n  KEY `exec_result` (`exec_result`)\n) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='\u6267\u884c\u8bb0\u5f55\u8868';");
        }
        logger.info("success init table");
    }

    public boolean checkTableExist(String tableName) {
        try {
            this.jdbcTemplate.update("SHOW CREATE TABLE " + tableName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<Task> getWaitExecTask(int size) {
        String ip = IpUtil.getLocalIp();
        Object[] params = new Object[]{ip, ip, size};
        return this.jdbcTemplate.query(Constants.SQL_QUERY_WAITE_EXEC_TASK_LIST, params, (RowMapper)new TaskRowMapper());
    }

    public boolean lockTask(Task task) {
        return this.jdbcTemplate.update(Constants.SQL_QUERY_LOCK_TASK, new Object[]{IpUtil.getLocalIp(), task.getId(), task.getExecTime()}) > 0;
    }

    public void releaseTask(Task task, TaskStatusEnum taskStatusEnum) {
        try {
            this.jdbcTemplate.update(Constants.SQL_RELEASE_TASK, new Object[]{taskStatusEnum.getStatus(), CronAnalysisUtil.getNextTime(task.getCronStr(), task.getExecTime()), task.getId()});
        }
        catch (Exception e) {
            logger.error("releaseTask error", (Throwable)e);
        }
    }

    public void failAndDisableTask(int id) {
        try {
            this.jdbcTemplate.update(Constants.SQL_FAIL_AND_RELEASE_TASK, new Object[]{id});
        }
        catch (Exception e) {
            logger.error("failAndDisableTask error", (Throwable)e);
        }
    }

    public void saveExecHistory(Task task, Date finishTime, ExecResultEnum execResult, String message) {
        try {
            long cost = finishTime == null ? 0L : finishTime.getTime() - task.getExecTime().getTime();
            this.jdbcTemplate.update("REPLACE INTO cenxt_exec_history (`task_id`, `exec_id`, `exec_ip`, `exec_time`, `finish_time`, `cost`, `exec_result`, `retry_times`, `success_count`, `fail_count`, `exec_message`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{task.getId(), task.getExecId(), IpUtil.getLocalIp(), task.getExecTime(), finishTime, cost, execResult.getResult(), 0, 0, 0, message});
        }
        catch (Exception e) {
            logger.error("insertExecHistory error", (Throwable)e);
        }
    }

    public void saveExecHistory(Task task, Date finishTime, ExecHistory execHistory) {
        if (execHistory.getExecMessage().length() > 10000) {
            execHistory.setExecMessage(execHistory.getExecMessage().substring(0, 10000));
        }
        try {
            this.jdbcTemplate.update("REPLACE INTO cenxt_exec_history (`task_id`, `exec_id`, `exec_ip`, `exec_time`, `finish_time`, `cost`, `exec_result`, `retry_times`, `success_count`, `fail_count`, `exec_message`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{task.getId(), task.getExecId(), IpUtil.getLocalIp(), task.getExecTime(), finishTime, execHistory.getCost(), execHistory.getExecResult(), execHistory.getRetryTimes(), execHistory.getExecReport().getSuccessCount(), execHistory.getExecReport().getFailCount(), execHistory.getExecMessage()});
        }
        catch (Exception e) {
            logger.error("insertExecHistory error", (Throwable)e);
        }
    }

    public Date getNowTime() {
        try {
            return (Date)this.jdbcTemplate.queryForObject("SELECT NOW()", (RowMapper)new RowMapper<Date>(){

                public Date mapRow(ResultSet resultSet, int i) throws SQLException {
                    return resultSet.getTimestamp(1);
                }
            });
        }
        catch (Exception e) {
            logger.error("getNowTime error", (Throwable)e);
            return new Date();
        }
    }

    public List<Task> getAllTasks() {
        return this.jdbcTemplate.query("SELECT * FROM cenxt_task order by update_time desc", (RowMapper)new TaskRowMapper());
    }

    public List<ExecHistory> getExecHistory(int taskId, int size) {
        Object[] params = new Object[]{taskId, size};
        return this.jdbcTemplate.query("SELECT * FROM cenxt_exec_history WHERE task_id=? order by exec_time DESC LIMIT ?", params, (RowMapper)new ExecHistoryMapper());
    }

    public List<ExecHistory> getErrorExecHistory(int taskId, int size) {
        Object[] params = new Object[]{taskId, size};
        return this.jdbcTemplate.query(Constants.SQL_QUERY_ERROR_EXEC_HISTORY_LIST, params, (RowMapper)new ExecHistoryMapper());
    }

    public int deleteExecHistory(Date date, int size) {
        return this.jdbcTemplate.update("DELETE FROM cenxt_exec_history WHERE exec_time<? LIMIT ?", new Object[]{date, size});
    }

    public void saveTask(Task task, String username) {
        if (task.getId() > 0) {
            this.jdbcTemplate.update("UPDATE `cenxt_task` SET `name`=?, `description`=?, `cron_str`=?, `expire`=?, `retry_times`=?, `params`=?, `next_time`=?,`updator`=?, `update_time`=now() WHERE  `id`=?", new Object[]{task.getName(), task.getDescription(), task.getCronStr(), task.getExpire(), task.getRetryTimes(), task.getParams(), task.getNextTime(), username, task.getId()});
        } else {
            this.jdbcTemplate.update("INSERT INTO `cenxt_task` (`name`, `description`, `cron_str`, `expire`, `retry_times`, `params`, `next_time`, `create_time`, `creator`) \nVALUES (?, ?, ?, ?, ?, ?, ?, now(), ?);", new Object[]{task.getName(), task.getDescription(), task.getCronStr(), task.getExpire(), task.getRetryTimes(), task.getParams(), task.getNextTime(), username});
        }
    }

    public void enableTask(int id, boolean enabled, String username) {
        this.jdbcTemplate.update("UPDATE `cenxt_task` SET `enabled`=?,`updator`=?, `update_time`=now() WHERE  `id`=?", new Object[]{enabled ? 1 : 0, username, id});
    }

    public void deleteTask(int id) {
        this.jdbcTemplate.update("DELETE FROM `cenxt_task` WHERE  `id`=?", new Object[]{id});
    }
}

