/*
 * Decompiled with CFR 0.152.
 */
package cn.cenxt.task.scheduler;

import cn.cenxt.task.enums.ExecResultEnum;
import cn.cenxt.task.enums.TaskStatusEnum;
import cn.cenxt.task.jobs.CenxtJob;
import cn.cenxt.task.listeners.CenxtTaskListener;
import cn.cenxt.task.model.ExecHistory;
import cn.cenxt.task.model.Task;
import cn.cenxt.task.scheduler.ExecCallable;
import cn.cenxt.task.service.CenxtTaskService;
import com.alibaba.fastjson.JSON;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecWrapper
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(ExecWrapper.class);
    private Task task;
    private CenxtJob job;
    private CenxtTaskListener listener;
    private CenxtTaskService cenxtTaskService;

    public ExecWrapper(Task task, CenxtJob job, CenxtTaskListener listener, CenxtTaskService cenxtTaskService) {
        this.task = task;
        this.job = job;
        this.listener = listener;
        this.cenxtTaskService = cenxtTaskService;
    }

    @Override
    public void run() {
        this.cenxtTaskService.saveExecHistory(this.task, null, ExecResultEnum.RUNNING, null);
        ExecHistory execHistory = new ExecHistory();
        execHistory.setExecResult(ExecResultEnum.RUNNING.getResult());
        FutureTask<ExecHistory> futureTask = new FutureTask<ExecHistory>(new ExecCallable((Task)JSON.parseObject((String)JSON.toJSONString((Object)this.task), Task.class), this.job, this.listener, execHistory));
        Thread thread = new Thread(futureTask);
        thread.setName(this.task.getExecId());
        this.logger.info("task thread begin ,execId:{}", (Object)this.task.getExecId());
        thread.start();
        long start = System.currentTimeMillis();
        while (!futureTask.isDone()) {
            long cost = System.currentTimeMillis() - start;
            execHistory.setCost(cost);
            if (this.task.getExpire() > 0 && cost > (long)(this.task.getExpire() * 60 * 1000)) {
                try {
                    this.logger.error("task expire, will call cancel,execId:{}", (Object)this.task.getExecId());
                    futureTask.cancel(true);
                }
                catch (Exception e) {
                    this.logger.error("cancel error", (Throwable)e);
                }
                execHistory.setExecResult(ExecResultEnum.INTERRUPTED.getResult());
                execHistory.setExecMessage(execHistory.getExecMessage() + "\u3010\u9519\u8bef\u3011\u5728" + cost + "\u6beb\u79d2\u4e4b\u540e,\u4efb\u52a1\u88ab\u4e2d\u65ad");
            }
            if (execHistory.getExecResult() != ExecResultEnum.RUNNING.getResult() && execHistory.getExecResult() != ExecResultEnum.RETRYING.getResult()) break;
            this.cenxtTaskService.saveExecHistory(this.task, null, execHistory);
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {}
        }
        try {
            execHistory = futureTask.get(1L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.logger.error("futureTask get error", (Throwable)e);
        }
        this.cenxtTaskService.saveExecHistory(this.task, this.cenxtTaskService.getNowTime(), execHistory);
        if (execHistory.getExecResult() == ExecResultEnum.SUCCESS.getResult() || execHistory.getExecResult() == ExecResultEnum.RETRY_SUCCESS.getResult()) {
            this.cenxtTaskService.releaseTask(this.task, TaskStatusEnum.WAITING);
        } else {
            this.cenxtTaskService.releaseTask(this.task, TaskStatusEnum.FAIL);
        }
    }
}

