/*
 * Decompiled with CFR 0.152.
 */
package cn.cenxt.task.jobs;

import cn.cenxt.task.annotations.TaskInfo;
import cn.cenxt.task.jobs.CenxtJob;
import cn.cenxt.task.model.ExecReport;
import cn.cenxt.task.model.Task;
import cn.cenxt.task.service.CenxtTaskService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@TaskInfo(description="\u5220\u9664\u4efb\u52a1\u6267\u884c\u8bb0\u5f55", paramsDescription="{\n  \"?beforeDay\": \"\u5220\u9664\u591a\u5c11\u5929\u524d\u7684\u8bb0\u5f55\uff0c\u9ed8\u8ba43\",\n  \"beforeDay\": 5,\n  \"?size\": \"\u5220\u9664\u7684\u884c\u6570\uff0c\u9ed8\u8ba4100\",\n  \"size\": \"100\"\n}")
public class TaskExecHistoryClearJob
implements CenxtJob {
    private static Logger logger = LoggerFactory.getLogger(TaskExecHistoryClearJob.class);
    private static final String PARAM_BEFORE_DAY = "beforeDay";
    private static final String PARAM_SIZE = "size";
    @Autowired
    private CenxtTaskService cenxtTaskService;

    @Override
    public boolean exec(Task task, ExecReport execReport) throws Exception {
        logger.info(task.toString());
        int beforeDay = task.getParam(PARAM_BEFORE_DAY, Integer.class, 3);
        int size = task.getParam(PARAM_SIZE, Integer.class, 100);
        logger.info("beforeDay:{},size:{}", (Object)beforeDay, (Object)size);
        Date nowTime = this.cenxtTaskService.getNowTime();
        Date date = new Date(nowTime.getTime() - (long)(beforeDay * 24 * 60 * 60 * 1000));
        int count = this.cenxtTaskService.deleteExecHistory(date, size);
        execReport.incrSuccessCount(count);
        logger.info("delete success,count:{}", (Object)count);
        return true;
    }
}

