/*
 * Decompiled with CFR 0.152.
 */
package cn.cenxt.task.filter;

import cn.cenxt.task.enums.RoleEnum;
import cn.cenxt.task.service.CenxtSecurityService;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;

public class CenxtTaskFilter
implements Filter {
    private CenxtSecurityService securityService;

    public CenxtTaskFilter(CenxtSecurityService securityService) {
        this.securityService = securityService;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String url = request.getRequestURI();
        String[] urls = new String[]{request.getContextPath() + "/cenxt-task-view/api/login", request.getContextPath() + "/cenxt-task-view/#/login", request.getContextPath() + "/cenxt-task-view/#/", request.getContextPath() + "/cenxt-task-view/", request.getContextPath() + "/cenxt-task-view/css/**", request.getContextPath() + "/cenxt-task-view/fonts/**", request.getContextPath() + "/cenxt-task-view/img/**", request.getContextPath() + "/cenxt-task-view/js/**", request.getContextPath() + "/cenxt-task-view/favicon.ico", request.getContextPath() + "/cenxt-task-view/index.html"};
        AntPathMatcher pathMatcher = new AntPathMatcher();
        for (String str : urls) {
            if (!pathMatcher.match(str, url)) continue;
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String userName = this.securityService.getUserName(request);
        RoleEnum role = this.securityService.getRole(request);
        if (StringUtils.isEmpty((Object)userName) || role == null) {
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            response.getWriter().flush();
            return;
        }
        if (pathMatcher.match(request.getContextPath() + "/cenxt-task-view/api/admin/**", url) && role.getRole() < 1) {
            response.setStatus(HttpStatus.FORBIDDEN.value());
            response.getWriter().flush();
            return;
        }
        request.getSession().setAttribute("CENXT_TASK_USERNAME", (Object)userName);
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

