/*
 * Decompiled with CFR 0.152.
 */
package cn.cenxt.task.controller;

import cn.cenxt.task.annotations.TaskInfo;
import cn.cenxt.task.enums.RoleEnum;
import cn.cenxt.task.jobs.CenxtJob;
import cn.cenxt.task.model.CronExplain;
import cn.cenxt.task.model.ExecHistory;
import cn.cenxt.task.model.Login;
import cn.cenxt.task.model.Task;
import cn.cenxt.task.model.TaskDescription;
import cn.cenxt.task.properties.CenxtTaskProperties;
import cn.cenxt.task.service.CenxtSecurityService;
import cn.cenxt.task.service.CenxtTaskService;
import cn.cenxt.task.utils.CronAnalysisUtil;
import cn.cenxt.task.utils.IpUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.SessionAttribute;

@RestController
@RequestMapping(value={"/cenxt-task-view/api"})
public class ApiController {
    @Autowired
    private CenxtTaskService cenxtTaskService;
    @Autowired
    private CenxtSecurityService cenxtSecurityService;
    @Autowired
    private CenxtTaskProperties properties;
    @Autowired
    private ApplicationContext applicationContext;
    private static Map<String, Integer> loginMap = new ConcurrentHashMap<String, Integer>();

    @PostMapping(value={"/login"})
    public ResponseEntity<String> login(@RequestBody Login login, HttpServletRequest request) {
        if (StringUtils.isEmpty((Object)login.getPassword()) || StringUtils.isEmpty((Object)login.getUsername())) {
            return new ResponseEntity((Object)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", HttpStatus.BAD_REQUEST);
        }
        String ip = IpUtil.getIpAddr(request);
        if (loginMap.containsKey(ip) && loginMap.get(ip) >= this.properties.getView().getMaxTryCount()) {
            return new ResponseEntity((Object)"\u767b\u5f55\u5931\u8d25\u8d85\u8fc7\u9650\u5236\u6b21\u6570", HttpStatus.BAD_REQUEST);
        }
        RoleEnum role = null;
        if (login.getUsername().equals(this.properties.getView().getAdminUsername()) && login.getPassword().equals(this.properties.getView().getAdminPassword())) {
            role = RoleEnum.ADMIN;
        } else if (login.getUsername().equals(this.properties.getView().getGuestUsername()) && login.getPassword().equals(this.properties.getView().getGuestPassword())) {
            role = RoleEnum.GUEST;
        }
        if (role == null) {
            if (loginMap.containsKey(ip)) {
                loginMap.put(ip, loginMap.get(ip) + 1);
            } else {
                loginMap.put(ip, 1);
            }
            return new ResponseEntity((Object)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef", HttpStatus.BAD_REQUEST);
        }
        request.getSession().setAttribute("CENXT_TASK_USERNAME", (Object)login.getUsername());
        request.getSession().setAttribute("CENXT_TASK_USER_ROLE", (Object)role);
        loginMap.remove(ip);
        return ResponseEntity.ok((Object)role.toString());
    }

    @GetMapping(value={"/logout"})
    public ResponseEntity<String> logout(HttpSession session) {
        session.removeAttribute("CENXT_TASK_USERNAME");
        session.removeAttribute("CENXT_TASK_USER_ROLE");
        return ResponseEntity.ok((Object)"");
    }

    @GetMapping(value={"/tasks"})
    public ResponseEntity<List<Task>> tasks() {
        return ResponseEntity.ok(this.cenxtTaskService.getAllTasks());
    }

    @GetMapping(value={"/jobs"})
    public ResponseEntity<List<TaskDescription>> jobs() {
        String[] names = this.applicationContext.getBeanNamesForType(CenxtJob.class);
        ArrayList<TaskDescription> list = new ArrayList<TaskDescription>();
        for (String name : names) {
            TaskDescription description = new TaskDescription();
            description.setName(name);
            Class<?> aClass = this.applicationContext.getBean(name).getClass();
            TaskInfo taskInfo = aClass.getDeclaredAnnotation(TaskInfo.class);
            if (taskInfo != null) {
                description.setDescription(taskInfo.description());
                description.setParamsDescription(taskInfo.paramsDescription());
                description.setCron(taskInfo.cron());
                description.setExpire(taskInfo.expire());
                description.setRetryTimes(taskInfo.retryTimes());
            }
            list.add(description);
        }
        return ResponseEntity.ok(list);
    }

    @PostMapping(value={"/cron-explain"})
    public ResponseEntity<List<Date>> cronExpalin(@RequestBody CronExplain cronExplain) {
        return ResponseEntity.ok(CronAnalysisUtil.getNextExecTimeList(cronExplain.getCronStr(), new Date(), cronExplain.getSize()));
    }

    @GetMapping(value={"/exec-history/{taskId}/{size}"})
    public ResponseEntity<List<ExecHistory>> execHistory(@PathVariable(value="taskId") int taskId, @PathVariable(value="size") int size) {
        if (size < 1 || size > 100) {
            size = 10;
        }
        return ResponseEntity.ok(this.cenxtTaskService.getExecHistory(taskId, size));
    }

    @GetMapping(value={"/exec-history/error/{taskId}/{size}"})
    public ResponseEntity<List<ExecHistory>> errorExecHistory(@PathVariable(value="taskId") int taskId, @PathVariable(value="size") int size) {
        if (size < 1 || size > 100) {
            size = 10;
        }
        return ResponseEntity.ok(this.cenxtTaskService.getErrorExecHistory(taskId, size));
    }

    @PostMapping(value={"/admin/task"})
    public ResponseEntity<String> saveTask(@RequestBody Task task, @SessionAttribute(name="CENXT_TASK_USERNAME") String username) {
        this.cenxtTaskService.saveTask(task, username);
        return ResponseEntity.ok((Object)"");
    }

    @PostMapping(value={"/admin/task/enabled/{id}"})
    public ResponseEntity<String> enabledTask(@PathVariable(value="id") int id, @SessionAttribute(name="CENXT_TASK_USERNAME") String username) {
        this.cenxtTaskService.enableTask(id, true, username);
        return ResponseEntity.ok((Object)"");
    }

    @PostMapping(value={"/admin/task/disabled/{id}"})
    public ResponseEntity<String> disabledTask(@PathVariable(value="id") int id, @SessionAttribute(name="CENXT_TASK_USERNAME") String username) {
        this.cenxtTaskService.enableTask(id, false, username);
        return ResponseEntity.ok((Object)"");
    }

    @DeleteMapping(value={"/admin/task/{id}"})
    public ResponseEntity<String> deleteTask(@PathVariable(value="id") int id) {
        this.cenxtTaskService.deleteTask(id);
        return ResponseEntity.ok((Object)"");
    }
}

