/*
 * Decompiled with CFR 0.152.
 */
package cn.cenxt.task.utils;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class IpUtil {
    public static String getLocalIp() {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface item = e.nextElement();
                for (InterfaceAddress address : item.getInterfaceAddresses()) {
                    if (item.isLoopback() || !item.isUp() || !(address.getAddress() instanceof Inet4Address)) continue;
                    Inet4Address inet4Address = (Inet4Address)address.getAddress();
                    return inet4Address.getHostAddress();
                }
            }
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (SocketException | UnknownHostException e) {
            return "";
        }
    }
}

