/*
 * Decompiled with CFR 0.152.
 */
package cn.cenxt.task.scheduler;

import cn.cenxt.task.jobs.CenxtJob;
import cn.cenxt.task.listeners.CenxtTaskListener;
import cn.cenxt.task.model.Task;
import cn.cenxt.task.service.CenxtTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecWrapper
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(ExecWrapper.class);
    private Task task;
    private CenxtJob job;
    private CenxtTaskListener listener;
    private CenxtTaskService cenxtTaskService;

    public ExecWrapper(Task task, CenxtJob job, CenxtTaskListener listener, CenxtTaskService cenxtTaskService) {
        this.task = task;
        this.job = job;
        this.listener = listener;
        this.cenxtTaskService = cenxtTaskService;
    }

    @Override
    public void run() {
        Thread thread = new Thread(){
            private final Logger logger;
            {
                this.logger = LoggerFactory.getLogger((String)ExecWrapper.this.task.getName());
            }

            @Override
            public void run() {
                this.logger.info("task begin ,execId:{}", (Object)ExecWrapper.this.task.getExecId());
                long start = System.currentTimeMillis();
                boolean result = true;
                int i = 0;
                StringBuilder erroMsg = new StringBuilder();
                try {
                    ExecWrapper.this.listener.begin(ExecWrapper.this.task);
                }
                catch (Exception e) {
                    this.logger.warn("listener begin error", (Throwable)e);
                }
                int retryTimes = Math.max(ExecWrapper.this.task.getRetryTimes(), 0);
                while (i <= retryTimes) {
                    block26: {
                        long step = System.currentTimeMillis();
                        if (i > 0) {
                            this.logger.info("task retry ,execId:{},retryTimes:{}", (Object)ExecWrapper.this.task.getExecId(), (Object)i);
                            try {
                                ExecWrapper.this.listener.retry(ExecWrapper.this.task, i);
                            }
                            catch (Exception e) {
                                this.logger.warn("listener retry error", (Throwable)e);
                            }
                        }
                        try {
                            ExecWrapper.this.job.pre(ExecWrapper.this.task);
                            result = ExecWrapper.this.job.exec(ExecWrapper.this.task);
                        }
                        catch (InterruptedException ex) {
                            this.logger.error("task interrupted ,execId:{}", (Object)ExecWrapper.this.task.getExecId());
                            try {
                                ExecWrapper.this.listener.fail(ExecWrapper.this.task, System.currentTimeMillis() - step, i + 1, ex);
                            }
                            catch (Exception e) {
                                this.logger.warn("listener fail error", (Throwable)e);
                            }
                            break;
                        }
                        catch (Exception ex) {
                            this.logger.error("task exec error, execId:{}", (Object)ExecWrapper.this.task.getExecId(), (Object)ex);
                            erroMsg.append(ex.getMessage()).append("\n");
                            try {
                                ExecWrapper.this.listener.fail(ExecWrapper.this.task, System.currentTimeMillis() - step, i + 1, ex);
                            }
                            catch (Exception e) {
                                this.logger.warn("listener fail error", (Throwable)e);
                            }
                            break block26;
                        }
                        if (result) break;
                        erroMsg.append("[").append(i).append("] ").append("job return error").append("\n");
                        try {
                            ExecWrapper.this.listener.fail(ExecWrapper.this.task, System.currentTimeMillis() - step, i + 1, null);
                        }
                        catch (Exception e) {
                            this.logger.warn("listener fail error", (Throwable)e);
                        }
                    }
                    ++i;
                }
                int execResult = 0;
                if (!result) {
                    execResult = 2;
                } else if (i > 0) {
                    execResult = 1;
                }
                this.logger.info("task finished ,execId:{},execResult:{}", (Object)ExecWrapper.this.task.getExecId(), (Object)execResult);
                try {
                    ExecWrapper.this.cenxtTaskService.insertExecHistory(ExecWrapper.this.task.getId(), ExecWrapper.this.task.getExecId(), ExecWrapper.this.task.getExecTime(), ExecWrapper.this.cenxtTaskService.getNowTime(), execResult, erroMsg.toString());
                }
                catch (Exception e) {
                    this.logger.error("insertExecHistory error", (Throwable)e);
                }
                try {
                    ExecWrapper.this.cenxtTaskService.releaseTask(ExecWrapper.this.task, execResult);
                }
                catch (Exception e) {
                    this.logger.error("releaseTask error", (Throwable)e);
                }
                long cost = System.currentTimeMillis() - start;
                try {
                    if (result) {
                        ExecWrapper.this.listener.finish(ExecWrapper.this.task, cost, i);
                    } else {
                        ExecWrapper.this.listener.exceptionFinish(ExecWrapper.this.task, cost, i - 1);
                    }
                }
                catch (Exception e) {
                    this.logger.warn("listener finish error", (Throwable)e);
                }
            }
        };
        thread.setName(this.task.getExecId());
        try {
            this.log.info("task thread begin ,execId:{}", (Object)this.task.getExecId());
            thread.start();
            if (this.task.getExpire() > 0) {
                thread.join(this.task.getExpire() * 60 * 1000);
                thread.interrupt();
            } else {
                thread.join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

