/*
 * Decompiled with CFR 0.152.
 */
package cn.caohongliang.mybatis.generator.plugin;

import cn.caohongliang.mybatis.generator.util.PluginUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class ServicePlugin
extends PluginAdapter {
    private String basePackage;

    public boolean validate(List<String> warnings) {
        return true;
    }

    public void setProperties(Properties properties) {
        this.basePackage = PluginUtils.getString(properties, "basePackage", null);
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(IntrospectedTable introspectedTable) {
        if (PluginUtils.isEmpty(this.basePackage)) {
            throw new NullPointerException("basePackage can't be null");
        }
        String entityName = introspectedTable.getBaseRecordType();
        entityName = entityName.substring(entityName.lastIndexOf(".") + 1);
        ArrayList<GeneratedJavaFile> generatedJavaFiles = new ArrayList<GeneratedJavaFile>();
        Interface serviceInterface = new Interface(this.basePackage + "." + entityName + "Service");
        List javaDocLines = serviceInterface.getJavaDocLines();
        PluginUtils.classComment(javaDocLines, introspectedTable, entityName, " Service");
        String targetProject = this.context.getJavaClientGeneratorConfiguration().getTargetProject();
        String fileName = serviceInterface.getType().getShortName() + ".java";
        boolean existFile = PluginUtils.existFile(targetProject, this.basePackage, fileName);
        if (!existFile) {
            GeneratedJavaFile serviceInterfaceFile = new GeneratedJavaFile((CompilationUnit)serviceInterface, targetProject, this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
            serviceInterface.setVisibility(JavaVisibility.PUBLIC);
            generatedJavaFiles.add(serviceInterfaceFile);
        }
        TopLevelClass serviceImpl = new TopLevelClass(this.basePackage + ".impl." + entityName + "ServiceImpl");
        serviceImpl.setVisibility(JavaVisibility.PUBLIC);
        serviceImpl.addAnnotation("@Service");
        serviceImpl.addSuperInterface(serviceInterface.getType());
        serviceImpl.addImportedType(serviceInterface.getType());
        serviceImpl.addImportedType("org.springframework.stereotype.Service");
        javaDocLines = serviceImpl.getJavaDocLines();
        PluginUtils.classComment(javaDocLines, introspectedTable, entityName, " ServiceImpl");
        fileName = serviceImpl.getType().getShortName() + ".java";
        existFile = PluginUtils.existFile(targetProject, serviceImpl.getType().getPackageName(), fileName);
        if (!existFile) {
            GeneratedJavaFile serviceImplFile = new GeneratedJavaFile((CompilationUnit)serviceImpl, targetProject, this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
            generatedJavaFiles.add(serviceImplFile);
        }
        return generatedJavaFiles;
    }
}

