/*
 * Decompiled with CFR 0.152.
 */
package cn.caohongliang.mybatis.generator.plugin;

import cn.caohongliang.mybatis.generator.util.PluginUtils;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class EntityPlugin
extends PluginAdapter {
    private static final String PRIMARY_KEY_PACKAGE = "key";
    private static final String EXAMPLE_PACKAGE = "example";

    public boolean validate(List<String> warnings) {
        return true;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        List javaDocLines = topLevelClass.getJavaDocLines();
        String defaultRemarks = topLevelClass.getType().getShortName();
        PluginUtils.classComment(javaDocLines, introspectedTable, defaultRemarks, " Entity");
        this.addLombokAnnotation(topLevelClass);
        topLevelClass.addAnnotation("@Builder");
        topLevelClass.addImportedType("lombok.Builder");
        return true;
    }

    private void addLombokAnnotation(TopLevelClass topLevelClass) {
        topLevelClass.addAnnotation("@Data");
        topLevelClass.addAnnotation("@NoArgsConstructor");
        topLevelClass.addAnnotation("@AllArgsConstructor");
        topLevelClass.addImportedType("lombok.Data");
        topLevelClass.addImportedType("lombok.NoArgsConstructor");
        topLevelClass.addImportedType("lombok.AllArgsConstructor");
    }

    public boolean modelFieldGenerated(Field field, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        List javaDocLines = field.getJavaDocLines();
        javaDocLines.clear();
        String remarks = PluginUtils.isEmpty(introspectedColumn.getRemarks()) ? field.getName() : introspectedColumn.getRemarks();
        javaDocLines.add("/**");
        javaDocLines.add(" * " + remarks);
        javaDocLines.add(" */");
        field.addAnnotation("@ApiModelProperty(\"" + remarks + "\")");
        topLevelClass.addImportedType("io.swagger.annotations.ApiModelProperty");
        return true;
    }

    public boolean modelGetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return false;
    }

    public boolean modelSetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return false;
    }

    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addLombokAnnotation(topLevelClass);
        FullyQualifiedJavaType type = topLevelClass.getType();
        Class<?> typeClass = type.getClass();
        try {
            java.lang.reflect.Method method = typeClass.getDeclaredMethod("simpleParse", String.class);
            method.setAccessible(true);
            String primaryKeyType = type.getPackageName() + this.wrapper(PRIMARY_KEY_PACKAGE) + type.getShortNameWithoutTypeArguments();
            method.invoke((Object)type, primaryKeyType);
            introspectedTable.setPrimaryKeyType(primaryKeyType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public boolean modelExampleClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        FullyQualifiedJavaType type = topLevelClass.getType();
        String exampleType = type.getPackageName() + this.wrapper(EXAMPLE_PACKAGE) + type.getShortNameWithoutTypeArguments();
        PluginUtils.setMethodValue(type, "simpleParse", exampleType, String.class);
        introspectedTable.setExampleType(exampleType);
        return true;
    }

    private String wrapper(String str) {
        return "." + str + ".";
    }
}

