/**
 * Created by ByWei.Cn on 2019/5/20.
 */
layui.config({
    base: 'webjars/swagger-lazydoc/assets/layext/'
}).extend({
    nlaytpl: 'nlaytpl',
    ncmntool: 'ncmntool',
    nswagger: 'nswagger',
    nupload: 'nupload'
});
//
layui.use(['layer', 'element', 'form', 'nlaytpl', 'nswagger', 'ncmntool', 'upload'], function () {
    var $ = layui.jquery,
        layer = layui.layer,
        element = layui.element,
        form = layui.form,
        ncmntool = layui.ncmntool,
        nlaytpl = layui.nlaytpl,
        nswagger = layui.nswagger;

    $(".logo").click(function () {
        $(".nav-home").click();
        $(".layui-side-scroll").scrollTop(0);
    });
    function getContextPath() {
        var pathName = document.location.pathname;
        var index = pathName.substr(1).indexOf("/");
        var result = pathName.substr(0,index+1);
        if(result.indexOf("webjars") > 0){
        	return "";
        }
        return result;
    }
    //获取锚点参数
    function getNavApi(){
    	var navapi = window.location.hash;
    	if(navapi == null || navapi.length <= 1){
    		return null;
    	}
    	return navapi.split('#')[1];
    }
    function getRequestTree(){
    	var contextPath = getContextPath();
        // 弹出加载框
        var loader = layer.load();
        var iptApiUrl = contextPath + "/v2/api-docs";
        $.ajax({
            url: iptApiUrl,
            dataType: "json",
            type: "get",
            success: function (apidoc) {
                // 解析数据
                try {
                    nswagger.resolve(apidoc);
                } catch (e) {
                    layer.msg('解析失败，请确认文档配置是否正确', {icon: 5});
                    console.error(e);
                    return;
                }
                // 设置页面标题
                document.title = apidoc.info.title + ' swagger-lazydoc';
                // 设置页面LOGO
                ncmntool.checkimg(apidoc.schemes[0] + "://" + apidoc.host + apidoc.basePath + "/logo.png", function (imgurl) {
                    $(".logo img").attr("src", imgurl);
                });
                //location.hash = apidoc.host;
                // 渲染左侧菜单导航
                nlaytpl.render(".api-main")("webjars/swagger-lazydoc/comp/tplApiMain.html", {tags: apidoc["tags"]}, function () {
                    // 重新渲染菜单效果
                    element.init();
                    // 监听导航点击事件
                    element.on("nav(left-nav)", function (ele) {
                        if ($(ele).hasClass("nav-home")) {
                            nlaytpl.render(".main-body")("webjars/swagger-lazydoc/comp/tplHomeBody.html", apidoc, function () {
                                // 重新渲染组件效果
                                element.init();
                            });
                        } else {
                            $((".layui-nav-itemed")).removeClass(("layui-nav-itemed"));
                            $(ele).parents(".layui-nav-item").addClass("layui-nav-itemed");
                            var _a = $(ele).children(':first-child');
                            $(".layui-side-scroll").scrollTop($(_a).offset().top - $(".layui-side").offset().top + $(".layui-side").scrollTop());
                            var _dpath = $(_a).attr("dpath"), _dhttpmethod = $(_a).attr("dhttpmethod");
                            nlaytpl.render(".main-body")("webjars/swagger-lazydoc/comp/tplApiBody.html", {
                                apidoc: apidoc,
                                tagname: $(_a).attr("dtag"),
                                dpath: _dpath,
                                dhttpmethod: _dhttpmethod,
                                mmeta: apidoc["paths"][_dpath][_dhttpmethod]
                            }, function () {
                                // 重新渲染组件效果
                                element.init();
                                form.render();
                            });
                        }
                    });
                    // 监听处理导航的悬浮提示
                    $('.layui-nav-item a[dtitle]').on('mouseover', function () {
                        var that = this;
                        layer.tips($(that).attr("dtitle"), that, {
                            time: 0
                        });
                    }).on('mouseout', function () {
                        layer.closeAll('tips');
                    });
                    // 渲染主页或导航链接
                    $(".nav-home a").click();
                    var navapi = getNavApi();
                    if(navapi != null){
                    	$.each(apidoc["tags"], function (i, tag) {
                    		$.each(tag.paths, function (j, path) {
                    			if(navapi == path.path){
                    				$(".left-nav a[dpath='" + path.path + "'][dhttpmethod='" + path.httpmethod + "']").click();
                    			}
                    		});
                    	});
                    }
                });
                // 渲染顶部导航搜索
                nlaytpl.render(".api-quick")("webjars/swagger-lazydoc/comp/tplApiQuick.html", {tags: apidoc["tags"]}, function () {
                    form.on('select(api-quick)', function (data) {
                        var pm = data.value.split("::");
                        $(".left-nav a[dpath='" + pm[1] + "'][dhttpmethod='" + pm[0] + "']").click();
                    });
                    // 重新渲染表单组件效果
                    form.render("select");
                });
            },
            error: function () {
                layer.msg('加载失败，请确认API文档的地址是否正确', {icon: 5});
            },
            complete: function () {
                layer.close(loader);
            }
        });
    }
    //
    getRequestTree();
});