/*
 * Decompiled with CFR 0.152.
 */
package cn.bytengine.d.assist;

import cn.bytengine.d.assist.ClassAccessor;
import cn.bytengine.d.assist.ClassAccessorRegister;
import cn.bytengine.d.lang.reflect.ClassInfo;
import cn.bytengine.d.lang.reflect.ClassInfos;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class ClassAccessors {
    private static final Map<Class<?>, ClassAccessor> classAccessorMap = new HashMap(16);
    private static final Map<String, ClassAccessor> classNameAccessorMap = new HashMap<String, ClassAccessor>(16);

    public static void load() {
        ClassAccessorRegister.load();
    }

    public static ClassAccessor register(Class<?> key) {
        if (ClassAccessors.containsClass(key)) {
            return ClassAccessors.get(key);
        }
        ClassInfo[] classInfos = ClassInfos.register((Class[])new Class[]{key});
        ClassAccessor classAccessor = new ClassAccessor(classInfos[0]);
        classAccessorMap.put(key, classAccessor);
        classNameAccessorMap.put(key.getCanonicalName(), classAccessor);
        return classAccessor;
    }

    public static Collection<ClassAccessor> classAccessors() {
        return classAccessorMap.values();
    }

    public static Set<Map.Entry<Class<?>, ClassAccessor>> classes() {
        return classAccessorMap.entrySet();
    }

    public static void each(BiConsumer<? super Class<?>, ? super ClassAccessor> action) {
        classAccessorMap.forEach(action);
    }

    public static boolean containsClass(String key) {
        return classNameAccessorMap.containsKey(key);
    }

    public static boolean containsClass(Class<?> key) {
        return classAccessorMap.containsKey(key);
    }

    public static boolean containsClassAccessor(ClassInfo value) {
        return ClassAccessors.containsClassAccessor(new ClassAccessor(value));
    }

    public static boolean containsClassAccessor(ClassAccessor value) {
        return classAccessorMap.containsValue(value);
    }

    public static ClassAccessor get(Class<?> key) {
        return classAccessorMap.get(key);
    }

    public static ClassAccessor get(String key) {
        return classNameAccessorMap.get(key);
    }

    public static ClassAccessor[] of(Class<?> ... classes) {
        return (ClassAccessor[])Arrays.stream(classes).map(ClassAccessors::register).toArray(ClassAccessor[]::new);
    }
}

