/*
 * Decompiled with CFR 0.152.
 */
package cn.bytengine.d.assist;

import cn.bytengine.d.assist.MethodAccessor;
import cn.bytengine.d.assist.PropertyAccessor;
import cn.bytengine.d.fn.invoker.MetaInfoInvoker;
import cn.bytengine.d.fn.invoker.ReflectionOperationException;
import cn.bytengine.d.lang.reflect.ClassInfo;
import cn.bytengine.d.lang.reflect.MethodInfo;
import cn.bytengine.d.lang.reflect.PropertyInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ClassAccessor {
    private final ClassInfo classInfo;
    private final Map<String, PropertyAccessor> propertyAccessorMap = new HashMap<String, PropertyAccessor>(16);
    private final Map<String, MethodAccessor> methodAccessorMap = new HashMap<String, MethodAccessor>(16);

    public ClassAccessor(ClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public void addMethodAccessor(MetaInfoInvoker invoker) {
        MethodInfo methodInfo = invoker.getMethodInfo();
        if (this.methodAccessorMap.containsKey(methodInfo.getMethodName())) {
            return;
        }
        if (!this.classInfo.getType().equals(methodInfo.getOwnClass())) {
            throw new ReflectionOperationException("The invoker is not element in this class");
        }
        this.methodAccessorMap.put(methodInfo.getMethodName(), new MethodAccessor(methodInfo, invoker));
    }

    public MethodAccessor getMethodAccessor(String methodName) {
        return this.methodAccessorMap.get(methodName);
    }

    public boolean containMethod(String methodName) {
        return this.methodAccessorMap.containsKey(methodName);
    }

    public void addPropertyAccessor(String propertyName) {
        if (this.propertyAccessorMap.containsKey(propertyName)) {
            return;
        }
        if (!this.classInfo.containsProperty(propertyName)) {
            throw new ReflectionOperationException("The property is not element in this class");
        }
        PropertyInfo propertyInfo = this.classInfo.getProperty(propertyName);
        MethodAccessor getter = propertyInfo.isCanRead() ? this.methodAccessorMap.get(propertyInfo.getGetter().getMethodName()) : null;
        MethodAccessor setter = propertyInfo.isCanWrite() ? this.methodAccessorMap.get(propertyInfo.getSetter().getMethodName()) : null;
        this.propertyAccessorMap.put(propertyName, new PropertyAccessor(propertyInfo, getter, setter));
    }

    public PropertyAccessor getPropertyAccessor(String propertyName) {
        return this.propertyAccessorMap.get(propertyName);
    }

    public boolean containProperty(String propertyName) {
        return this.propertyAccessorMap.containsKey(propertyName);
    }

    public <T> T get(Object me, String propertyName) {
        PropertyAccessor accessor = this.getPropertyAccessor(propertyName);
        if (accessor == null) {
            throw new ReflectionOperationException("The property is not element in this class");
        }
        return (T)accessor.get(me);
    }

    public void set(Object me, String propertyName, Object value) {
        PropertyAccessor accessor = this.getPropertyAccessor(propertyName);
        if (accessor == null) {
            throw new ReflectionOperationException("The property is not element in this class");
        }
        accessor.set(me, value);
    }

    public <T> T invoke(Object me, String methodName, Object ... args) {
        MethodAccessor accessor = this.getMethodAccessor(methodName);
        if (accessor == null) {
            throw new ReflectionOperationException("The method is not element in this class");
        }
        return (T)accessor.invoke(me, args);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassAccessor that = (ClassAccessor)o;
        return Objects.equals(this.classInfo, that.classInfo);
    }

    public int hashCode() {
        return Objects.hashCode(this.classInfo);
    }
}

