/*
 * Decompiled with CFR 0.152.
 */
package cn.byteforge.openqq.ws.handler;

import cn.byteforge.openqq.ws.BotContext;
import cn.byteforge.openqq.ws.event.Event;
import cn.byteforge.openqq.ws.event.EventListener;
import cn.byteforge.openqq.ws.handler.APICallbackHandler;
import cn.byteforge.openqq.ws.handler.AutoReconnectHandler;
import cn.byteforge.openqq.ws.handler.ErrorCheckHandler;
import cn.byteforge.openqq.ws.handler.EventDispatchHandler;
import cn.byteforge.openqq.ws.handler.EventParseHandler;
import cn.byteforge.openqq.ws.handler.HeartbeatHandler;
import cn.byteforge.openqq.ws.handler.SequenceHandler;
import cn.hutool.core.lang.Assert;
import java.util.UUID;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public abstract class ChainHandler {
    private UUID uuid;
    private BotContext context;
    private ChainHandler nextHandler;

    public Object handle(Object o) {
        if (o == null) {
            return null;
        }
        Object r = this.doHandle(o);
        if (this.nextHandler != null) {
            return this.nextHandler.handle(r);
        }
        return r;
    }

    public ChainHandler next() {
        return this.nextHandler;
    }

    @Nullable
    public <T extends ChainHandler> T find(Class<T> clazz) {
        ChainHandler inst = this;
        while (inst != null) {
            if (clazz.isInstance(inst)) {
                return (T)inst;
            }
            inst = inst.nextHandler;
        }
        return null;
    }

    public void setMetaData(UUID uuid, BotContext context) {
        Assert.isTrue((this.uuid == null && this.context == null ? 1 : 0) != 0, (String)"ChainHandler metadata is set repeatedly", (Object[])new Object[0]);
        this.uuid = uuid;
        this.context = context;
    }

    protected abstract Object doHandle(Object var1);

    protected ChainHandler setNext(ChainHandler handler) {
        this.nextHandler = handler;
        return this.nextHandler;
    }

    @SafeVarargs
    public static ChainHandler defaultChainGroup(@Nullable Consumer<UUID> reconnectCallback, EventListener<? extends Event> ... listeners) {
        return ChainHandler.builder().append(new ErrorCheckHandler()).append(new EventParseHandler()).append(new HeartbeatHandler()).append(new SequenceHandler.Received()).append(new AutoReconnectHandler(reconnectCallback)).append(new APICallbackHandler()).append(new EventDispatchHandler(listeners)).append(new SequenceHandler.Handled()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected UUID getUuid() {
        return this.uuid;
    }

    protected BotContext getContext() {
        return this.context;
    }

    public static final class Builder {
        private ChainHandler start;
        private ChainHandler end;

        public Builder append(ChainHandler handler) {
            if (this.start == null) {
                this.start = this.end = handler;
            } else {
                this.end = this.end.setNext(handler);
            }
            return this;
        }

        public ChainHandler build() {
            return this.start;
        }
    }
}

