/*
 * Decompiled with CFR 0.152.
 */
package cn.byteforge.openqq.ws.event.type;

import cn.byteforge.openqq.http.entity.MessageResponse;
import cn.byteforge.openqq.message.Message;
import cn.byteforge.openqq.message.MessageBuilder;
import cn.byteforge.openqq.ws.entity.data.MessageData;
import cn.byteforge.openqq.ws.event.Event;
import cn.hutool.core.lang.Assert;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MessageEvent
extends Event {
    private String id;
    private transient MessageData d;
    private final transient AtomicInteger msgSeq = new AtomicInteger(1);

    public MessageResponse reply(String message) {
        return this.reply(new MessageBuilder().addText(message).build());
    }

    public MessageResponse reply(Message message) {
        Assert.isTrue((this.getMsgSeq().get() <= 4 ? 1 : 0) != 0, (String)"\u8fbe\u5230\u6700\u5927\u56de\u590d\u6b21\u6570\u9650\u5236", (Object[])new Object[0]);
        return this.sendMessage(new MessageBuilder().addMessage(message).setPassive(this.getD().getId(), this.getMsgSeq().getAndIncrement()).build());
    }

    public MessageResponse sendMessage(String message) {
        return this.sendMessage(new MessageBuilder().addText(message).build());
    }

    public abstract MessageResponse sendMessage(Message var1);

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageEvent)) {
            return false;
        }
        MessageEvent other = (MessageEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MessageEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MessageEvent(super=" + super.toString() + ", id=" + this.getId() + ", d=" + this.getD() + ", msgSeq=" + this.getMsgSeq() + ")";
    }

    public String getId() {
        return this.id;
    }

    @Override
    public MessageData getD() {
        return this.d;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setD(MessageData d) {
        this.d = d;
    }

    protected AtomicInteger getMsgSeq() {
        return this.msgSeq;
    }
}

