/*
 * Decompiled with CFR 0.152.
 */
package cn.byteforge.openqq.ws;

import cn.byteforge.openqq.util.Maps;
import cn.byteforge.openqq.ws.BotContext;
import cn.byteforge.openqq.ws.QQConnection;
import cn.byteforge.openqq.ws.entity.Intent;
import cn.byteforge.openqq.ws.entity.Session;
import cn.byteforge.openqq.ws.entity.Shard;
import cn.byteforge.openqq.ws.entity.enumerate.OpCode;
import cn.byteforge.openqq.ws.handler.APICallbackHandler;
import cn.byteforge.openqq.ws.handler.ChainHandler;
import cn.byteforge.openqq.ws.handler.EventParseHandler;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Pair;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelId;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketAPI {
    private static final Logger log = LoggerFactory.getLogger(WebSocketAPI.class);
    public static final String NO_NEED_CALLBACK = null;

    public static Session newStandaloneSession(Intent intent, UUID uuid, @Nullable Map<String, Object> properties, BotContext context) {
        return WebSocketAPI.newShardSession(intent, uuid, Shard.STANDALONE, properties, context);
    }

    public static Session newShardSession(Intent intent, UUID uuid, Shard shard, @Nullable Map<String, Object> properties, BotContext context) {
        context.configureShard(uuid, shard);
        CompletableFuture<JsonObject> future = WebSocketAPI.send(Maps.of("op", OpCode.IDENTIFY.getCode(), "d", Maps.of("token", String.format("QQBot %s", context.getCertificate().getAccessToken().getContent()), "intents", intent.getValue(), "shard", shard.toArray(), "properties", properties)), uuid, "READY", context);
        JsonObject json = future.join();
        Assert.notNull((Object)json);
        Session session = (Session)EventParseHandler.GSON.fromJson((JsonElement)json, Session.class);
        if (context.getSessionMap().containsKey(uuid)) {
            log.info("Duplicated session detected, is this in resume session or reconnect ?");
        }
        return session;
    }

    public static void resumeSession(UUID uuid, BotContext context) {
        Map<UUID, Session> sessionMap = context.getSessionMap();
        Session oldSession = sessionMap.get(uuid);
        Assert.notNull((Object)oldSession);
        CompletableFuture<JsonObject> future = WebSocketAPI.send(Maps.of("op", OpCode.RESUME.getCode(), "d", Maps.of("token", String.format("QQBot %s", context.getCertificate().getAccessToken().getContent()), "session_id", oldSession.getSessionId(), "seq", context.getHandledSeqMap().get(uuid))), uuid, "RESUMED", context);
        Assert.notNull((Object)future.join(), (String)"Resume session failed, is it invalid ?", (Object[])new Object[0]);
        log.info("Resume session: {}", (Object)oldSession);
    }

    public static CompletableFuture<@Nullable JsonObject> send(Object payload, UUID uuid, @Nullable String callbackName, BotContext context) {
        String json = EventParseHandler.GSON.toJson(payload);
        log.info("Send json object: {}", (Object)json);
        Pair<ChannelId, ChainHandler> chainPair = context.getConnMap().get(uuid);
        ChannelFuture channelFuture = QQConnection.CLIENT_GROUPS.find((ChannelId)chainPair.getKey()).writeAndFlush((Object)new TextWebSocketFrame(json));
        return CompletableFuture.supplyAsync(() -> {
            try {
                channelFuture.sync();
                APICallbackHandler handler = ((ChainHandler)chainPair.getValue()).find(APICallbackHandler.class);
                Assert.notNull((Object)handler, (String)"APICallbackHandler must be appended before invoke ws api", (Object[])new Object[0]);
                return Objects.requireNonNull(handler).getCallback(callbackName);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

