/*
 * Decompiled with CFR 0.152.
 */
package cn.byteforge.openqq.ws;

import cn.byteforge.openqq.QQHelper;
import cn.byteforge.openqq.http.OpenAPI;
import cn.byteforge.openqq.http.entity.RecommendShard;
import cn.byteforge.openqq.ws.BotContext;
import cn.byteforge.openqq.ws.EventChannelHandler;
import cn.byteforge.openqq.ws.entity.Session;
import cn.byteforge.openqq.ws.handler.ChainHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.URI;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QQConnection {
    private static final Logger log = LoggerFactory.getLogger(QQConnection.class);
    public static final ChannelGroup CLIENT_GROUPS = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);

    public static void reconnect(UUID uuid, BotContext context, @Nullable Consumer<UUID> callback) {
        QQConnection.doConnect(context, null, null, uuid, callback);
    }

    public static void connect(BotContext context, Supplier<ChainHandler> handlerSupplier, Function<UUID, Session> sessionFunction, @Nullable Consumer<UUID> callback) {
        QQConnection.doConnect(context, handlerSupplier, sessionFunction, null, callback);
    }

    private static void doConnect(BotContext context, @Nullable Supplier<ChainHandler> handlerSupplier, @Nullable Function<UUID, Session> sessionFunction, @Nullable UUID _uuid, @Nullable Consumer<UUID> callback) {
        context.getExecutor().submit(() -> {
            UUID uuid = _uuid != null ? _uuid : UUID.randomUUID();
            ChainHandler chainHandler = QQConnection.getChainHandler(handlerSupplier, uuid, context);
            final EventChannelHandler eventHandler = new EventChannelHandler(chainHandler);
            ScheduledExecutorService tokenService = Executors.newScheduledThreadPool(1);
            NioEventLoopGroup group = new NioEventLoopGroup();
            try {
                Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                    protected void initChannel(@NotNull SocketChannel ch) {
                        ch.pipeline().addLast(new ChannelHandler[]{new SslHandler(SslContextBuilder.forClient().build().newEngine(ch.alloc()))}).addLast(new ChannelHandler[]{new HttpClientCodec()}).addLast(new ChannelHandler[]{new ChunkedWriteHandler()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(0x100000)}).addLast(new ChannelHandler[]{eventHandler});
                    }
                });
                RecommendShard shard = OpenAPI.getRecommendShardWssUrls(context.getCertificate());
                URI uri = new URI(shard.getUrl());
                WebSocketClientHandshaker handshake = WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, null);
                Channel channel = bootstrap.connect(uri.getHost(), 443).sync().channel();
                eventHandler.setHandshaker(handshake);
                handshake.handshake(channel);
                eventHandler.getHandshakeFuture().sync();
                CLIENT_GROUPS.add((Object)channel);
                context.bindChannel(uuid, channel.id(), chainHandler);
                for (ChainHandler next = chainHandler; next != null; next = next.next()) {
                    next.setMetaData(uuid, context);
                }
                context.initSession(uuid, sessionFunction);
                tokenService.schedule(QQHelper.refreshTokenRunnable(uuid, context), (long)Integer.parseInt(context.getCertificate().getAccessToken().getExpiresIn()), TimeUnit.SECONDS);
                if (callback != null) {
                    callback.accept(uuid);
                }
                channel.closeFuture().sync();
            }
            catch (Exception e) {
                log.error("Exception occurred in wss connection", (Throwable)e);
            }
            finally {
                Channel channel = CLIENT_GROUPS.find((ChannelId)context.getConnMap().get(uuid).getKey());
                CLIENT_GROUPS.remove((Object)channel);
                tokenService.shutdownNow();
                try {
                    group.shutdownGracefully().sync();
                }
                catch (InterruptedException interruptedException) {}
                log.info("Connection closed, please make sure that there is a another connection established ...");
            }
        });
    }

    private static ChainHandler getChainHandler(@Nullable Supplier<ChainHandler> handlerSupplier, UUID uuid, BotContext context) {
        if (handlerSupplier != null) {
            context.getChainSupplierMap().put(uuid, handlerSupplier);
            return handlerSupplier.get();
        }
        return context.getChainSupplierMap().get(uuid).get();
    }
}

