/*
 * Decompiled with CFR 0.152.
 */
package cn.byteforge.openqq.ws;

import cn.byteforge.openqq.exception.InvalidShardException;
import cn.byteforge.openqq.http.OpenAPI;
import cn.byteforge.openqq.http.entity.AccessToken;
import cn.byteforge.openqq.model.Certificate;
import cn.byteforge.openqq.ws.entity.Session;
import cn.byteforge.openqq.ws.entity.Shard;
import cn.byteforge.openqq.ws.handler.ChainHandler;
import cn.hutool.core.lang.Pair;
import io.netty.channel.ChannelId;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BotContext {
    private static final Logger log = LoggerFactory.getLogger(BotContext.class);
    private final ExecutorService executor;
    private final Certificate certificate;
    private Map<UUID, Pair<ChannelId, ChainHandler>> connMap = new ConcurrentHashMap<UUID, Pair<ChannelId, ChainHandler>>();
    private Map<UUID, Supplier<ChainHandler>> chainSupplierMap = new ConcurrentHashMap<UUID, Supplier<ChainHandler>>();
    private Pair<UUID, Shard>[] shardsConfigured;
    private Map<UUID, Session> sessionMap = new ConcurrentHashMap<UUID, Session>();
    private Map<UUID, Function<UUID, Session>> sessionFuncMap = new ConcurrentHashMap<UUID, Function<UUID, Session>>();
    private Map<UUID, Long> receivedSeqMap = new ConcurrentHashMap<UUID, Long>();
    private Map<UUID, Long> handledSeqMap = new ConcurrentHashMap<UUID, Long>();

    protected void configureShard(UUID uuid, Shard shard) {
        try {
            if (this.shardsConfigured == null) {
                this.shardsConfigured = new Pair[shard.getSize().intValue()];
            }
            this.shardsConfigured[shard.getIndex().intValue()] = new Pair((Object)uuid, (Object)shard);
        }
        catch (Exception e) {
            throw new InvalidShardException(shard, this.shardsConfigured);
        }
    }

    protected void bindChannel(UUID uuid, ChannelId id, ChainHandler chainHandler) {
        this.connMap.put(uuid, (Pair<ChannelId, ChainHandler>)new Pair((Object)id, (Object)chainHandler));
    }

    protected void initSession(UUID uuid, @Nullable Function<UUID, Session> sessionFunction) {
        if (sessionFunction != null) {
            this.sessionFuncMap.put(uuid, sessionFunction);
        } else {
            sessionFunction = this.sessionFuncMap.get(uuid);
        }
        this.sessionMap.put(uuid, sessionFunction.apply(uuid));
    }

    public static BotContext create(String appId, String clientSecret, ExecutorService executor) {
        AccessToken token = OpenAPI.getAppAccessToken(appId, clientSecret);
        Certificate certificate = new Certificate(appId, clientSecret, token);
        return new BotContext(executor, certificate);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public Map<UUID, Pair<ChannelId, ChainHandler>> getConnMap() {
        return this.connMap;
    }

    public Map<UUID, Supplier<ChainHandler>> getChainSupplierMap() {
        return this.chainSupplierMap;
    }

    public Pair<UUID, Shard>[] getShardsConfigured() {
        return this.shardsConfigured;
    }

    public Map<UUID, Session> getSessionMap() {
        return this.sessionMap;
    }

    public Map<UUID, Function<UUID, Session>> getSessionFuncMap() {
        return this.sessionFuncMap;
    }

    public Map<UUID, Long> getReceivedSeqMap() {
        return this.receivedSeqMap;
    }

    public Map<UUID, Long> getHandledSeqMap() {
        return this.handledSeqMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BotContext)) {
            return false;
        }
        BotContext other = (BotContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExecutorService this$executor = this.getExecutor();
        ExecutorService other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        Certificate this$certificate = this.getCertificate();
        Certificate other$certificate = other.getCertificate();
        if (this$certificate == null ? other$certificate != null : !this$certificate.equals(other$certificate)) {
            return false;
        }
        Map<UUID, Pair<ChannelId, ChainHandler>> this$connMap = this.getConnMap();
        Map<UUID, Pair<ChannelId, ChainHandler>> other$connMap = other.getConnMap();
        if (this$connMap == null ? other$connMap != null : !((Object)this$connMap).equals(other$connMap)) {
            return false;
        }
        Map<UUID, Supplier<ChainHandler>> this$chainSupplierMap = this.getChainSupplierMap();
        Map<UUID, Supplier<ChainHandler>> other$chainSupplierMap = other.getChainSupplierMap();
        if (this$chainSupplierMap == null ? other$chainSupplierMap != null : !((Object)this$chainSupplierMap).equals(other$chainSupplierMap)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getShardsConfigured(), other.getShardsConfigured())) {
            return false;
        }
        Map<UUID, Session> this$sessionMap = this.getSessionMap();
        Map<UUID, Session> other$sessionMap = other.getSessionMap();
        if (this$sessionMap == null ? other$sessionMap != null : !((Object)this$sessionMap).equals(other$sessionMap)) {
            return false;
        }
        Map<UUID, Function<UUID, Session>> this$sessionFuncMap = this.getSessionFuncMap();
        Map<UUID, Function<UUID, Session>> other$sessionFuncMap = other.getSessionFuncMap();
        if (this$sessionFuncMap == null ? other$sessionFuncMap != null : !((Object)this$sessionFuncMap).equals(other$sessionFuncMap)) {
            return false;
        }
        Map<UUID, Long> this$receivedSeqMap = this.getReceivedSeqMap();
        Map<UUID, Long> other$receivedSeqMap = other.getReceivedSeqMap();
        if (this$receivedSeqMap == null ? other$receivedSeqMap != null : !((Object)this$receivedSeqMap).equals(other$receivedSeqMap)) {
            return false;
        }
        Map<UUID, Long> this$handledSeqMap = this.getHandledSeqMap();
        Map<UUID, Long> other$handledSeqMap = other.getHandledSeqMap();
        return !(this$handledSeqMap == null ? other$handledSeqMap != null : !((Object)this$handledSeqMap).equals(other$handledSeqMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BotContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExecutorService $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        Certificate $certificate = this.getCertificate();
        result = result * 59 + ($certificate == null ? 43 : $certificate.hashCode());
        Map<UUID, Pair<ChannelId, ChainHandler>> $connMap = this.getConnMap();
        result = result * 59 + ($connMap == null ? 43 : ((Object)$connMap).hashCode());
        Map<UUID, Supplier<ChainHandler>> $chainSupplierMap = this.getChainSupplierMap();
        result = result * 59 + ($chainSupplierMap == null ? 43 : ((Object)$chainSupplierMap).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getShardsConfigured());
        Map<UUID, Session> $sessionMap = this.getSessionMap();
        result = result * 59 + ($sessionMap == null ? 43 : ((Object)$sessionMap).hashCode());
        Map<UUID, Function<UUID, Session>> $sessionFuncMap = this.getSessionFuncMap();
        result = result * 59 + ($sessionFuncMap == null ? 43 : ((Object)$sessionFuncMap).hashCode());
        Map<UUID, Long> $receivedSeqMap = this.getReceivedSeqMap();
        result = result * 59 + ($receivedSeqMap == null ? 43 : ((Object)$receivedSeqMap).hashCode());
        Map<UUID, Long> $handledSeqMap = this.getHandledSeqMap();
        result = result * 59 + ($handledSeqMap == null ? 43 : ((Object)$handledSeqMap).hashCode());
        return result;
    }

    public String toString() {
        return "BotContext(executor=" + this.getExecutor() + ", certificate=" + this.getCertificate() + ", connMap=" + this.getConnMap() + ", chainSupplierMap=" + this.getChainSupplierMap() + ", shardsConfigured=" + Arrays.deepToString(this.getShardsConfigured()) + ", sessionMap=" + this.getSessionMap() + ", sessionFuncMap=" + this.getSessionFuncMap() + ", receivedSeqMap=" + this.getReceivedSeqMap() + ", handledSeqMap=" + this.getHandledSeqMap() + ")";
    }

    private BotContext(ExecutorService executor, Certificate certificate) {
        this.executor = executor;
        this.certificate = certificate;
    }
}

