/*
 * Decompiled with CFR 0.152.
 */
package cn.byteforge.openqq.message;

import cn.byteforge.openqq.exception.ConflictMessageTypeException;
import cn.byteforge.openqq.http.entity.entry.KeyValueEntry;
import cn.byteforge.openqq.http.entity.entry.LinkedTextEntry;
import cn.byteforge.openqq.message.Message;
import cn.byteforge.openqq.util.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class MessageBuilder {
    private final Map<String, Object> data = new HashMap<String, Object>();

    public MessageBuilder() {
        this.data.put("content", new StringBuilder());
    }

    public MessageBuilder addText(String text) {
        ((StringBuilder)this.data.get("content")).append(text);
        this.updateMsgType(0);
        return this;
    }

    @Deprecated
    public MessageBuilder addAtText(String userId) {
        ((StringBuilder)this.data.get("content")).append("<@").append(userId).append('>');
        this.updateMsgType(0);
        return this;
    }

    public MessageBuilder addTemplateMarkdown(String templateId, String keyValuesJson) {
        JsonArray keyValues = (JsonArray)new Gson().fromJson(keyValuesJson, JsonArray.class);
        return this.addTemplateMarkdown(templateId, keyValues.asList());
    }

    public MessageBuilder addTemplateMarkdown(String templateId, JsonArray keyValues) {
        return this.addTemplateMarkdown(templateId, keyValues.asList());
    }

    public MessageBuilder addTemplateMarkdown(String templateId, List<?> keyValues) {
        this.data.put("markdown", Maps.of("custom_template_id", templateId, "params", keyValues, "keyboard", Maps.of("id", templateId)));
        this.updateMsgType(2);
        return this;
    }

    public MessageBuilder addCustomMarkdown(String content) {
        this.data.put("markdown", new KeyValueEntry("content", content));
        this.updateMsgType(2);
        return this;
    }

    @Deprecated
    public MessageBuilder addTemplateMarkdownButton(String templateId) {
        this.data.put("keyboard", Maps.of("id", templateId));
        this.updateMsgType(2);
        return this;
    }

    public MessageBuilder addCustomMarkdownButton(String rowsJson, String appId) {
        JsonArray rows = (JsonArray)new Gson().fromJson(rowsJson, JsonArray.class);
        this.data.put("keyboard", Maps.of("content", Maps.of("rows", rows, "bot_appid", appId)));
        this.updateMsgType(2);
        return this;
    }

    public MessageBuilder addLinkedTextListArk(String desc, String prompt, List<LinkedTextEntry> entryList) {
        LinkedList<Map<String, List<KeyValueEntry>>> obj = new LinkedList<Map<String, List<KeyValueEntry>>>();
        for (LinkedTextEntry entry : entryList) {
            obj.add(Maps.of("obj_kv", Arrays.asList(new KeyValueEntry("desc", entry.getDesc()), new KeyValueEntry("link", entry.getLink()))));
        }
        return this.addArk(23, Arrays.asList(new KeyValueEntry("#DESC#", desc), new KeyValueEntry("#PROMPT#", prompt), new KeyValueEntry("#LIST#", obj)));
    }

    public MessageBuilder addSmallPicArk(String desc, String prompt, String title, String metaDesc, String img, String link, String subTitle) {
        return this.addArk(24, Arrays.asList(new KeyValueEntry("#DESC#", desc), new KeyValueEntry("#PROMPT#", prompt), new KeyValueEntry("#TITLE#", title), new KeyValueEntry("#METADESC#", metaDesc), new KeyValueEntry("#IMG#", img), new KeyValueEntry("#LINK#", link), new KeyValueEntry("#SUBTITLE#", subTitle)));
    }

    @Deprecated
    public MessageBuilder addBigPicArk(String prompt, String metaTitle, String metaSubTitle, String metaCover, String metaAurl) {
        return this.addArk(37, Arrays.asList(new KeyValueEntry("#PROMPT#", prompt), new KeyValueEntry("#METATITLE#", metaTitle), new KeyValueEntry("#METASUBTITLE#", metaSubTitle), new KeyValueEntry("#METACOVER#", metaCover), new KeyValueEntry("#METAURL#", metaAurl)));
    }

    public MessageBuilder addArk(int templateId, JsonArray keyValues) {
        return this.addArk(templateId, keyValues.asList());
    }

    public MessageBuilder addArk(int templateId, List<?> keyValues) {
        this.data.put("ark", Maps.of("template_id", templateId, "kv", keyValues));
        this.updateMsgType(3);
        return this;
    }

    public MessageBuilder addMedia(String fileInfo) {
        this.data.put("media", Maps.of("file_info", fileInfo));
        this.updateMsgType(7);
        return this;
    }

    public MessageBuilder setPassive(String msgId) {
        return this.setPassive(msgId, null);
    }

    public MessageBuilder setPassive(String msgId, @Nullable Integer msgSeq) {
        this.data.put("msg_id", msgId);
        this.data.put("msg_seq", msgSeq);
        return this;
    }

    public MessageBuilder addMessage(Message message) {
        this.data.putAll(message.getData());
        return this;
    }

    public Message build() {
        return new Message(this.data);
    }

    private void updateMsgType(int msgType) {
        Object recordType = this.data.get("msg_type");
        if (recordType == null) {
            this.data.put("msg_type", msgType);
            return;
        }
        if ((Integer)recordType == msgType) {
            return;
        }
        if (msgType == 0 && (Integer)recordType == 7) {
            return;
        }
        if ((Integer)recordType == 0 && msgType == 7) {
            return;
        }
        throw new ConflictMessageTypeException(msgType, (Integer)recordType);
    }
}

