/*
 * Decompiled with CFR 0.152.
 */
package cn.byteforge.openqq.http.entity;

import cn.byteforge.openqq.exception.UnknownStatusException;

public class Status {

    public static final class Http {
        private final int code;
        private final String message;
        private final boolean success;

        public static Http parse(int code) {
            switch (code) {
                case 200: {
                    return new Http(200, "\u6210\u529f", true);
                }
                case 204: {
                    return new Http(204, "\u6210\u529f\uff0c\u4f46\u662f\u65e0\u5305\u4f53\uff0c\u4e00\u822c\u7528\u4e8e\u5220\u9664\u64cd\u4f5c", true);
                }
                case 201: 
                case 202: {
                    return new Http(code, "\u5f02\u6b65\u64cd\u4f5c\u6210\u529f\uff0c\u867d\u7136\u8bf4\u6210\u529f\uff0c\u4f46\u662f\u4f1a\u8fd4\u56de\u4e00\u4e2a error body\uff0c\u9700\u8981\u7279\u6b8a\u5904\u7406", false);
                }
                case 401: {
                    return new Http(401, "\u8ba4\u8bc1\u5931\u8d25", false);
                }
                case 404: {
                    return new Http(404, "\u672a\u627e\u5230 API", false);
                }
                case 405: {
                    return new Http(405, "http method \u4e0d\u5141\u8bb8", false);
                }
                case 429: {
                    return new Http(429, "\u9891\u7387\u9650\u5236", false);
                }
                case 500: 
                case 504: {
                    return new Http(code, "\u5904\u7406\u5931\u8d25", false);
                }
            }
            throw new UnknownStatusException(code);
        }

        public Http(int code, String message, boolean success) {
            this.code = code;
            this.message = message;
            this.success = success;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Http)) {
                return false;
            }
            Http other = (Http)o;
            if (this.getCode() != other.getCode()) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCode();
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "Status.Http(code=" + this.getCode() + ", message=" + this.getMessage() + ", success=" + this.isSuccess() + ")";
        }
    }
}

