/*
 * Decompiled with CFR 0.152.
 */
package cn.byteforge.openqq;

import cn.byteforge.openqq.http.OpenAPI;
import cn.byteforge.openqq.http.entity.AccessToken;
import cn.byteforge.openqq.model.Certificate;
import cn.byteforge.openqq.ws.BotContext;
import cn.byteforge.openqq.ws.QQConnection;
import io.netty.channel.ChannelId;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QQHelper {
    private static final Logger log = LoggerFactory.getLogger(QQHelper.class);

    public static Runnable refreshTokenRunnable(UUID uuid, BotContext context) {
        return QQHelper.refreshTokenRunnable(0, uuid, context);
    }

    public static Runnable refreshTokenRunnable(int thresholdSeconds, UUID uuid, BotContext context) {
        return () -> {
            log.info("Start trying to update AccessToken");
            Certificate certificate = context.getCertificate();
            if (!certificate.getAccessToken().expired(thresholdSeconds)) {
                log.warn("AccessToken no expired, is it expired ?");
                return;
            }
            AccessToken token = OpenAPI.getAppAccessToken(certificate.getAppId(), certificate.getClientSecret());
            certificate.updateToken(token);
            log.info("AccessToken auto refreshed: {}", (Object)token.getContent());
        };
    }

    public static void closeChannel(UUID uuid, BotContext context) {
        QQConnection.CLIENT_GROUPS.find((ChannelId)context.getConnMap().get(uuid).getKey()).close().sync();
    }
}

