/*
 * Decompiled with CFR 0.152.
 */
package cn.byteforge.openqq.ws.handler;

import cn.byteforge.openqq.task.HeartbeatRunnable;
import cn.byteforge.openqq.ws.event.Event;
import cn.byteforge.openqq.ws.handler.ChainHandler;
import com.google.gson.JsonObject;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatHandler
extends ChainHandler {
    private static final Logger log = LoggerFactory.getLogger(HeartbeatHandler.class);
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> scheduledFuture;

    @Override
    protected Object doHandle(Object o) {
        Event event = (Event)o;
        switch (event.getOpcode()) {
            case HELLO: {
                if (this.scheduledFuture != null) {
                    this.scheduledFuture.cancel(true);
                    log.info("Duplicate heartbeat thread detected, is this connection reconnect ?");
                }
                long interval = ((JsonObject)event.getD()).get("heartbeat_interval").getAsLong();
                interval -= interval / 10L * 2L;
                this.scheduledFuture = this.executor.scheduleAtFixedRate(new HeartbeatRunnable(this.getUuid(), this.getContext()), interval, interval, TimeUnit.MILLISECONDS);
                log.debug("Heartbeat thread start");
                return null;
            }
            case HEARTBEAT: {
                log.debug("Received HEARTBEAT");
                return null;
            }
            case HEARTBEAT_ACK: {
                log.debug("Received HEARTBEAT_ACK");
                return null;
            }
        }
        return event;
    }
}

