/*
 * Decompiled with CFR 0.152.
 */
package cn.byteforge.openqq.ws.handler;

import cn.byteforge.openqq.ws.QQConnection;
import cn.byteforge.openqq.ws.entity.enumerate.OpCode;
import cn.byteforge.openqq.ws.event.Event;
import cn.byteforge.openqq.ws.handler.ChainHandler;
import java.util.UUID;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoReconnectHandler
extends ChainHandler {
    private static final Logger log = LoggerFactory.getLogger(AutoReconnectHandler.class);
    private final String wssUrl;
    private final Consumer<UUID> reconnectCallback;

    @Override
    protected Object doHandle(Object o) {
        Event event = (Event)o;
        if (event.getOpcode() == OpCode.RECONNECT) {
            QQConnection.reconnect(this.wssUrl, this.getUuid(), this.getContext(), this.reconnectCallback);
            log.info("QQ connection of uuid-{} already auto reconnected", (Object)this.getUuid());
            return null;
        }
        return o;
    }

    public AutoReconnectHandler(String wssUrl, Consumer<UUID> reconnectCallback) {
        this.wssUrl = wssUrl;
        this.reconnectCallback = reconnectCallback;
    }
}

