/*
 * Decompiled with CFR 0.152.
 */
package cn.byteforge.openqq.ws.handler;

import cn.byteforge.openqq.ws.event.Event;
import cn.byteforge.openqq.ws.handler.ChainHandler;
import cn.hutool.core.lang.Assert;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jetbrains.annotations.Nullable;

public class APICallbackHandler
extends ChainHandler {
    private final Map<String, BlockingQueue<JsonObject>> dataMap = new HashMap<String, BlockingQueue<JsonObject>>();

    public APICallbackHandler() {
        this.initDataMap();
    }

    private void initDataMap() {
        List<String> eventTypes = Arrays.asList("READY", "RESUMED");
        for (String eventType : eventTypes) {
            this.dataMap.computeIfAbsent(eventType, k -> new LinkedBlockingQueue());
        }
    }

    @Override
    protected Object doHandle(Object o) {
        Event event = (Event)o;
        switch (event.getEventType()) {
            case "READY": {
                this.dataMap.get("READY").put((JsonObject)event.getD());
                return null;
            }
            case "RESUMED": {
                this.dataMap.get("RESUMED").put(new JsonObject());
                return null;
            }
        }
        return o;
    }

    @Nullable
    public JsonObject getCallback(@Nullable String eventName) throws InterruptedException {
        if (eventName == null) {
            return null;
        }
        BlockingQueue<JsonObject> queue = this.dataMap.get(eventName);
        Assert.notNull(queue, (String)String.format("Unregistered event return type: %s", eventName), (Object[])new Object[0]);
        return queue.take();
    }
}

