/*
 * Decompiled with CFR 0.152.
 */
package cn.byteforge.openqq.ws.entity.enumerate;

import cn.byteforge.openqq.exception.UnknownOpCodeException;
import java.util.Arrays;

public enum OpCode {
    DISPATCH(0, "Dispatch", "Receive", "\u670d\u52a1\u7aef\u8fdb\u884c\u6d88\u606f\u63a8\u9001"),
    HEARTBEAT(1, "Heartbeat", "Send/Receive", "\u5ba2\u6237\u7aef\u6216\u670d\u52a1\u7aef\u53d1\u9001\u5fc3\u8df3"),
    IDENTIFY(2, "Identify", "Send", "\u5ba2\u6237\u7aef\u53d1\u9001\u9274\u6743"),
    RESUME(6, "Resume", "Send", "\u5ba2\u6237\u7aef\u6062\u590d\u8fde\u63a5"),
    RECONNECT(7, "Reconnect", "Receive", "\u670d\u52a1\u7aef\u901a\u77e5\u5ba2\u6237\u7aef\u91cd\u65b0\u8fde\u63a5"),
    INVALID_SESSION(9, "Invalid Session", "Receive", "\u5f53 identify \u6216 resume \u7684\u65f6\u5019\uff0c\u5982\u679c\u53c2\u6570\u6709\u9519\uff0c\u670d\u52a1\u7aef\u4f1a\u8fd4\u56de\u8be5\u6d88\u606f"),
    HELLO(10, "Hello", "Receive", "\u5f53\u5ba2\u6237\u7aef\u4e0e\u7f51\u5173\u5efa\u7acb ws \u8fde\u63a5\u4e4b\u540e\uff0c\u7f51\u5173\u4e0b\u53d1\u7684\u7b2c\u4e00\u6761\u6d88\u606f"),
    HEARTBEAT_ACK(11, "Heartbeat ACK", "Receive/Reply", "\u5f53\u53d1\u9001\u5fc3\u8df3\u6210\u529f\u4e4b\u540e\uff0c\u5c31\u4f1a\u6536\u5230\u8be5\u6d88\u606f"),
    HTTP_CALLBACK_ACK(12, "HTTP Callback ACK", "Reply", "\u4ec5\u7528\u4e8e http \u56de\u8c03\u6a21\u5f0f\u7684\u56de\u5305\uff0c\u4ee3\u8868\u673a\u5668\u4eba\u6536\u5230\u4e86\u5e73\u53f0\u63a8\u9001\u7684\u6570\u636e");

    private final Integer code;
    private final String name;
    private final String clientMethod;
    private final String description;

    public static OpCode parse(int code) {
        return Arrays.stream(OpCode.values()).filter(o -> o.code == code).findFirst().orElseThrow(() -> new UnknownOpCodeException(code));
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getClientMethod() {
        return this.clientMethod;
    }

    public String getDescription() {
        return this.description;
    }

    private OpCode(Integer code, String name, String clientMethod, String description) {
        this.code = code;
        this.name = name;
        this.clientMethod = clientMethod;
        this.description = description;
    }
}

