/*
 * Decompiled with CFR 0.152.
 */
package cn.byteforge.openqq.ws.entity;

import cn.hutool.core.lang.Assert;

public class Shard {
    public static final Shard STANDALONE = new Shard(0, 1);
    private final Integer index;
    private final Integer size;

    private Shard(Integer index, Integer size) {
        this.index = index;
        this.size = size;
        Assert.isTrue((0 <= index && index < size ? 1 : 0) != 0);
    }

    public int[] toArray() {
        return new int[]{this.index, this.size};
    }

    public static Shard[] generate(int size) {
        Shard[] shards = new Shard[size];
        for (int i = 0; i < size; ++i) {
            shards[i] = new Shard(i, size);
        }
        return shards;
    }

    public static Shard generateOne(int index, int size) {
        return new Shard(index, size);
    }

    public Integer getIndex() {
        return this.index;
    }

    public Integer getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Shard)) {
            return false;
        }
        Shard other = (Shard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$index = this.getIndex();
        Integer other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        Integer this$size = this.getSize();
        Integer other$size = other.getSize();
        return !(this$size == null ? other$size != null : !((Object)this$size).equals(other$size));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Shard;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        Integer $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        return result;
    }

    public String toString() {
        return "Shard(index=" + this.getIndex() + ", size=" + this.getSize() + ")";
    }
}

