/*
 * Decompiled with CFR 0.152.
 */
package cn.byteforge.openqq.ws;

import cn.byteforge.openqq.ws.BotContext;
import cn.byteforge.openqq.ws.EventChannelHandler;
import cn.byteforge.openqq.ws.WebSocketAPI;
import cn.byteforge.openqq.ws.entity.Session;
import cn.byteforge.openqq.ws.handler.ChainHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QQConnection {
    public static final ChannelGroup CLIENT_GROUPS = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);

    public static void reconnect(String wssUrl, UUID uuid, BotContext context, @Nullable Consumer<UUID> callback) throws InterruptedException {
        QQConnection.doConnect(wssUrl, null, context, null, uuid, id -> {
            WebSocketAPI.resumeSession(uuid, context);
            if (callback == null) {
                return;
            }
            callback.accept((UUID)id);
        });
    }

    public static void connect(String wssUrl, ChainHandler chainHandler, BotContext context, Function<UUID, Session> sessionFunction, @Nullable Consumer<UUID> callback) throws InterruptedException {
        QQConnection.doConnect(wssUrl, chainHandler, context, sessionFunction, null, callback);
    }

    private static void doConnect(String url, @Nullable ChainHandler chainHandler, BotContext context, @Nullable Function<UUID, Session> sessionFunction, @Nullable UUID uuid, @Nullable Consumer<UUID> callback) throws InterruptedException {
        final EventChannelHandler eventHandler = new EventChannelHandler(QQConnection.getChainHandler(chainHandler, uuid, context));
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(@NotNull SocketChannel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new SslHandler(SslContextBuilder.forClient().build().newEngine(ch.alloc()))}).addLast(new ChannelHandler[]{new HttpClientCodec()}).addLast(new ChannelHandler[]{new ChunkedWriteHandler()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(0x100000)}).addLast(new ChannelHandler[]{eventHandler});
                }
            });
            URI uri = new URI(url);
            WebSocketClientHandshaker handshake = WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, null);
            Channel channel = bootstrap.connect(uri.getHost(), 443).sync().channel();
            eventHandler.setHandshaker(handshake);
            handshake.handshake(channel);
            eventHandler.getHandshakeFuture().sync();
            CLIENT_GROUPS.add((Object)channel);
            if (uuid != null) {
                context.updateChannel(uuid, channel.id());
            } else {
                uuid = context.bindChannel(channel.id(), chainHandler);
                for (ChainHandler next = chainHandler; next != null; next = next.next()) {
                    next.setMetaData(uuid, context);
                }
                if (sessionFunction != null) {
                    context.getSessionMap().put(uuid, sessionFunction.apply(uuid));
                }
            }
            if (callback != null) {
                callback.accept(uuid);
            }
            channel.closeFuture().sync();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        finally {
            group.shutdownGracefully();
        }
    }

    private static ChainHandler getChainHandler(@Nullable ChainHandler chainHandler, @Nullable UUID uuid, BotContext context) {
        if (chainHandler != null) {
            return chainHandler;
        }
        return (ChainHandler)context.getConnMap().get(uuid).getValue();
    }
}

