/*
 * Decompiled with CFR 0.152.
 */
package cn.byteforge.openqq.ws;

import cn.byteforge.openqq.ws.handler.ChainHandler;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventChannelHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger log = LoggerFactory.getLogger(EventChannelHandler.class);
    private final ChainHandler chainHandler;
    private WebSocketClientHandshaker handshaker;
    private ChannelPromise handshakeFuture;

    public EventChannelHandler(ChainHandler chainHandler) {
        this.chainHandler = chainHandler;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (!this.handshaker.isHandshakeComplete()) {
            FullHttpResponse response = (FullHttpResponse)msg;
            this.handshaker.finishHandshake(ctx.channel(), response);
            this.handshakeFuture.setSuccess();
            return;
        }
        if (msg instanceof TextWebSocketFrame) {
            JsonObject json = (JsonObject)new Gson().fromJson(((TextWebSocketFrame)msg).text(), JsonObject.class);
            log.debug("Received json message: {}", (Object)json);
            try {
                this.chainHandler.handle(json);
            }
            catch (Exception e) {
                log.warn("Handler exception: ", (Throwable)e);
            }
        } else if (msg instanceof CloseWebSocketFrame) {
            log.info("WebSocket client closed with signal");
            ctx.channel().close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error("WebSocket connection closed with exception: ", cause);
        ctx.close();
    }

    public void setHandshaker(WebSocketClientHandshaker handshaker) {
        this.handshaker = handshaker;
    }

    public ChannelPromise getHandshakeFuture() {
        return this.handshakeFuture;
    }
}

