/*
 * Decompiled with CFR 0.152.
 */
package cn.byteforge.openqq.http;

import cn.byteforge.openqq.exception.APIInvokeException;
import cn.byteforge.openqq.http.entity.AccessToken;
import cn.byteforge.openqq.http.entity.FileInfo;
import cn.byteforge.openqq.http.entity.MessageResponse;
import cn.byteforge.openqq.http.entity.RecommendShard;
import cn.byteforge.openqq.http.entity.Status;
import cn.byteforge.openqq.http.entity.UploadFileType;
import cn.byteforge.openqq.message.Message;
import cn.byteforge.openqq.model.Certificate;
import cn.byteforge.openqq.util.Maps;
import cn.hutool.http.HttpGlobalConfig;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.Method;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPI {
    private static final Logger log = LoggerFactory.getLogger(OpenAPI.class);
    private static final Gson GSON = new GsonBuilder().create();

    public static MessageResponse sendGroupMessage(String groupId, Message message, Certificate cert) {
        return OpenAPI.getAuthResponse(String.format("https://api.sgroup.qq.com/v2/groups/%s/messages", groupId), message.getData(), Method.POST, cert, MessageResponse.class);
    }

    public static FileInfo uploadPrivateFile(String userId, String url, boolean send, UploadFileType type, Certificate cert) {
        return OpenAPI.doUploadGroupFile("users", userId, url, send, type, cert);
    }

    public static FileInfo uploadGroupFile(String groupId, String url, boolean send, UploadFileType type, Certificate cert) {
        return OpenAPI.doUploadGroupFile("groups", groupId, url, send, type, cert);
    }

    private static FileInfo doUploadGroupFile(String api, String openId, String url, boolean send, UploadFileType type, Certificate cert) {
        return OpenAPI.getAuthResponse(String.format("https://api.sgroup.qq.com/v2/%s/%s/files", api, openId), Maps.of("file_type", type.getValue(), "url", url, "srv_send_msg", send), Method.POST, cert, FileInfo.class);
    }

    public static AccessToken getAppAccessToken(String appId, String clientSecret) {
        return OpenAPI.getResponse("https://bots.qq.com/app/getAppAccessToken", Maps.of("appId", appId, "clientSecret", clientSecret), Method.POST, AccessToken.class, null);
    }

    public static String getUniversalWssUrl(Certificate cert) {
        return OpenAPI.getAuthResponse("https://api.sgroup.qq.com/gateway", null, Method.GET, cert, JsonObject.class).get("url").getAsString();
    }

    public static RecommendShard getRecommendShardWssUrls(Certificate cert) {
        return OpenAPI.getAuthResponse("https://api.sgroup.qq.com/gateway/bot", null, Method.GET, cert, RecommendShard.class);
    }

    private static <T> T getAuthResponse(String url, @Nullable Map<String, Object> data, Method method, Certificate cert, Class<T> clazz) {
        return OpenAPI.getResponse(url, data, method, clazz, Maps.of("Authorization", String.format("QQBot %s", cert.getAccessToken().getContent()), "X-Union-Appid", cert.getAppId()));
    }

    private static <T> T getResponse(String url, Map<String, Object> data, Method method, Class<T> clazz, Map<String, String> headers) {
        String body = GSON.toJson(data);
        log.debug("Send json object to url: {}, json: {}", (Object)url, (Object)body);
        try (HttpResponse response = ((HttpRequest)HttpRequest.of((String)url).method(method).timeout(HttpGlobalConfig.getTimeout()).body(body).headerMap(headers, true)).execute();){
            Status.Http httpStatus = Status.Http.parse(response.getStatus());
            if (!httpStatus.isSuccess() && response.bodyBytes().length == 0) {
                throw new APIInvokeException(httpStatus.getCode(), httpStatus.getMessage(), body);
            }
            JsonObject object = (JsonObject)GSON.fromJson(response.body(), JsonObject.class);
            if (object.has("code")) {
                throw new APIInvokeException(object.get("code").getAsInt(), object.get("message").getAsString(), body);
            }
            Object object2 = GSON.fromJson((JsonElement)object, clazz);
            return (T)object2;
        }
    }
}

