/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.thread;

import cn.buli_home.utils.thread.ExecutorBuilder;
import cn.buli_home.utils.thread.RejectPolicy;
import cn.buli_home.utils.thread.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;

public class ThreadUtils {
    public static ExecutorService newExecutor(int corePoolSize) {
        ExecutorBuilder builder = ExecutorBuilder.create();
        if (corePoolSize > 0) {
            builder.setCorePoolSize(corePoolSize);
        }
        return builder.build();
    }

    public static ExecutorService newExecutor() {
        return ExecutorBuilder.create().useSynchronousQueue().build();
    }

    public static ExecutorService newSingleExecutor() {
        return ExecutorBuilder.create().setCorePoolSize(1).setMaxPoolSize(1).setKeepAliveTime(0L).buildFinalizable();
    }

    public static ThreadPoolExecutor newExecutor(int corePoolSize, int maximumPoolSize) {
        return ExecutorBuilder.create().setCorePoolSize(corePoolSize).setMaxPoolSize(maximumPoolSize).build();
    }

    public static ExecutorService newExecutor(int corePoolSize, int maximumPoolSize, int maximumQueueSize) {
        return ExecutorBuilder.create().setCorePoolSize(corePoolSize).setMaxPoolSize(maximumPoolSize).setWorkQueue(new LinkedBlockingQueue<Runnable>(maximumQueueSize)).build();
    }

    public static ExecutorService newFixedExecutor(int nThreads, String threadNamePrefix, boolean isBlocked) {
        return ThreadUtils.newFixedExecutor(nThreads, 1024, threadNamePrefix, isBlocked);
    }

    public static ExecutorService newFixedExecutor(int nThreads, int maximumQueueSize, String threadNamePrefix, boolean isBlocked) {
        return ThreadUtils.newFixedExecutor(nThreads, maximumQueueSize, threadNamePrefix, (isBlocked ? RejectPolicy.BLOCK : RejectPolicy.ABORT).getValue());
    }

    public static ExecutorService newFixedExecutor(int nThreads, int maximumQueueSize, String threadNamePrefix, RejectedExecutionHandler handler) {
        return ExecutorBuilder.create().setCorePoolSize(nThreads).setMaxPoolSize(nThreads).setWorkQueue(new LinkedBlockingQueue<Runnable>(maximumQueueSize)).setThreadFactory(ThreadUtils.createThreadFactory(threadNamePrefix)).setHandler(handler).build();
    }

    public static ThreadFactory createThreadFactory(String threadNamePrefix) {
        return ThreadFactoryBuilder.create().setNamePrefix(threadNamePrefix).build();
    }
}

