/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.thread;

import cn.buli_home.utils.common.StringUtils;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import javafx.util.Builder;

public class ThreadFactoryBuilder
implements Builder<ThreadFactory>,
Serializable {
    private static final long serialVersionUID = 1L;
    private ThreadFactory backingThreadFactory;
    private String namePrefix;
    private Boolean daemon;
    private Integer priority;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public static ThreadFactoryBuilder create() {
        return new ThreadFactoryBuilder();
    }

    public ThreadFactoryBuilder setThreadFactory(ThreadFactory backingThreadFactory) {
        this.backingThreadFactory = backingThreadFactory;
        return this;
    }

    public ThreadFactoryBuilder setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
        return this;
    }

    public ThreadFactoryBuilder setDaemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public ThreadFactoryBuilder setPriority(int priority) {
        if (priority < 1) {
            throw new IllegalArgumentException(StringUtils.format("Thread priority ({}) must be >= {}", priority, 1));
        }
        if (priority > 10) {
            throw new IllegalArgumentException(StringUtils.format("Thread priority ({}) must be <= {}", priority, 10));
        }
        this.priority = priority;
        return this;
    }

    public ThreadFactoryBuilder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        return this;
    }

    public ThreadFactory build() {
        return ThreadFactoryBuilder.build(this);
    }

    private static ThreadFactory build(ThreadFactoryBuilder builder) {
        ThreadFactory backingThreadFactory = Objects.nonNull(builder.backingThreadFactory) ? builder.backingThreadFactory : Executors.defaultThreadFactory();
        String namePrefix = builder.namePrefix;
        Boolean daemon = builder.daemon;
        Integer priority = builder.priority;
        Thread.UncaughtExceptionHandler handler = builder.uncaughtExceptionHandler;
        AtomicLong count = null == namePrefix ? null : new AtomicLong();
        return r -> {
            Thread thread = backingThreadFactory.newThread(r);
            if (Objects.nonNull(namePrefix)) {
                thread.setName(namePrefix + count.getAndIncrement());
            }
            if (Objects.nonNull(daemon)) {
                thread.setDaemon(daemon);
            }
            if (Objects.nonNull(priority)) {
                thread.setPriority(priority);
            }
            if (Objects.nonNull(handler)) {
                thread.setUncaughtExceptionHandler(handler);
            }
            return thread;
        };
    }
}

