/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.thread;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;

public class BlockPolicy
implements RejectedExecutionHandler {
    private final Consumer<Runnable> handlerWhenShutdown;

    public BlockPolicy(Consumer<Runnable> handlerWhenShutdown) {
        this.handlerWhenShutdown = handlerWhenShutdown;
    }

    public BlockPolicy() {
        this(null);
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        if (!e.isShutdown()) {
            try {
                e.getQueue().put(r);
            }
            catch (InterruptedException ex) {
                throw new RejectedExecutionException("Task " + r + " rejected from " + e);
            }
        } else if (null != this.handlerWhenShutdown) {
            this.handlerWhenShutdown.accept(r);
        }
    }
}

