/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.net.http;

import cn.buli_home.utils.common.StringUtils;
import cn.buli_home.utils.net.http.HttpCallback;
import cn.buli_home.utils.net.http.HttpClientConfig;
import cn.buli_home.utils.net.http.HttpRequest;
import cn.buli_home.utils.net.http.HttpResponse;
import com.alibaba.fastjson2.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpUtils {
    private static final Logger log = LogManager.getLogger(HttpUtils.class);
    private static OkHttpClient httpClient = new OkHttpClient.Builder().build();
    private static OkHttpClient sslHttpClient = new OkHttpClient.Builder().sslSocketFactory(HttpClientConfig.sslSocketFactory(), HttpClientConfig.x509TrustManager()).hostnameVerifier(HttpClientConfig.hostnameVerifier()).build();
    private static List<Interceptor> interceptorList = new ArrayList<Interceptor>();
    private static List<Interceptor> networkInterceptorList = new ArrayList<Interceptor>();
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final MediaType MEDIA_TYPE_GENERAL = MediaType.parse((String)"application/octet-stream");
    private static final MediaType MEDIA_TYPE_IMAGE = MediaType.parse((String)"image/png");

    public static HttpResponse request(HttpRequest httpRequest) {
        try {
            log.info("\ud83d\udc4c\ud83d\udc4c\ud83d\udc4c okHttp send request: " + httpRequest);
            Request request = HttpUtils.p_generateRequest(httpRequest);
            HttpResponse response = HttpUtils.p_request(httpRequest, request);
            log.info("\ud83d\udc4c\ud83d\udc4c\ud83d\udc4c okHttp receive response: " + response);
            return response;
        }
        catch (Exception e) {
            log.error("\ud83d\udc4c\ud83d\udc4c\ud83d\udc4c " + e.getMessage());
            return HttpUtils.p_errorResponse(httpRequest, e);
        }
    }

    public static void addInterceptor(Interceptor ... interceptors) {
        interceptorList = Stream.concat(interceptorList.stream(), Arrays.stream(interceptors)).distinct().collect(Collectors.toList());
        log.info("\ud83d\udc4c\ud83d\udc4c\ud83d\udc4c okHttp add interceptors: " + interceptorList);
    }

    public static void addNetworkInterceptor(Interceptor ... interceptors) {
        networkInterceptorList = Stream.concat(networkInterceptorList.stream(), Arrays.stream(interceptors)).distinct().collect(Collectors.toList());
        log.info("\ud83d\udc4c\ud83d\udc4c\ud83d\udc4c okHttp add network interceptors: " + networkInterceptorList);
    }

    public static void clearInterceptor() {
        interceptorList.clear();
        log.info("\ud83d\udc4c\ud83d\udc4c\ud83d\udc4c okHttp clear interceptors.");
    }

    public static void clearNetworkInterceptor() {
        networkInterceptorList.clear();
        log.info("\ud83d\udc4c\ud83d\udc4c\ud83d\udc4c okHttp clear network interceptors.");
    }

    public static void buildClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        OkHttpClient.Builder sslBuilder = new OkHttpClient.Builder().sslSocketFactory(HttpClientConfig.sslSocketFactory(), HttpClientConfig.x509TrustManager()).hostnameVerifier(HttpClientConfig.hostnameVerifier());
        interceptorList.forEach(interceptor -> {
            builder.addInterceptor(interceptor);
            sslBuilder.addInterceptor(interceptor);
        });
        networkInterceptorList.forEach(interceptor -> {
            builder.addNetworkInterceptor(interceptor);
            sslBuilder.addNetworkInterceptor(interceptor);
        });
        httpClient = builder.build();
        sslHttpClient = sslBuilder.build();
        log.info("\ud83d\udc4c\ud83d\udc4c\ud83d\udc4c okHttp build client finished: " + interceptorList.size() + "interceptors, " + networkInterceptorList.size() + "networkInterceptors");
    }

    private static HttpResponse p_request(HttpRequest httpRequest, Request request) {
        Call call = httpRequest.isIgnoreSSL() ? sslHttpClient.newCall(request) : httpClient.newCall(request);
        switch (httpRequest.getRequestMode()) {
            case SYNCHRONOUS: {
                try {
                    Response response = call.execute();
                    return HttpUtils.p_convertResponse(response, httpRequest);
                }
                catch (IOException e) {
                    log.error("\ud83d\udc4c\ud83d\udc4c\ud83d\udc4c " + e.getMessage());
                    return HttpUtils.p_errorResponse(httpRequest, e);
                }
            }
            case ASYNCHRONOUS: {
                try {
                    HttpCallback callback = new HttpCallback();
                    call.enqueue((Callback)callback);
                    return HttpUtils.p_convertResponse((Response)callback.get(), httpRequest);
                }
                catch (Exception e) {
                    log.error("\ud83d\udc4c\ud83d\udc4c\ud83d\udc4c " + e.getMessage());
                    return HttpUtils.p_errorResponse(httpRequest, e);
                }
            }
        }
        return HttpUtils.p_errorResponse(httpRequest, new Exception("Unknown Request Mode!!!"));
    }

    private static HttpResponse p_convertResponse(Response response, HttpRequest httpRequest) {
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setHttpRequest(httpRequest);
        httpResponse.setCode(response.code());
        httpResponse.setSuccess(response.code() / 100 == 2);
        try {
            String string = StringUtils.convert2String(response.body().string());
            httpResponse.setBodyString(string);
            httpResponse.setBody(JSON.parseObject((String)string));
        }
        catch (IOException e) {
            log.error("\ud83d\udc4c\ud83d\udc4c\ud83d\udc4c " + e.getMessage());
        }
        return httpResponse;
    }

    private static String p_parseUrl(HttpRequest httpRequest) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)httpRequest.getUrl()).newBuilder();
        if (httpRequest.hasQueryParameter()) {
            httpRequest.getQueryParameter().forEach((arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
        }
        return urlBuilder.toString();
    }

    private static void p_addHeader(HttpRequest httpRequest, Request.Builder builder) {
        if (httpRequest.hasHeader()) {
            httpRequest.getHeader().forEach((arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        }
    }

    private static Request p_generateRequest(HttpRequest httpRequest) throws Exception {
        String url = HttpUtils.p_parseUrl(httpRequest);
        Request.Builder builder = new Request.Builder().url(url);
        HttpUtils.p_addHeader(httpRequest, builder);
        switch (httpRequest.getMethod()) {
            case GET: {
                builder.get();
                break;
            }
            case POST: {
                builder.post(HttpUtils.p_body(httpRequest));
                break;
            }
            case PUT: {
                builder.put(HttpUtils.p_body(httpRequest));
                break;
            }
            case DELETE: {
                builder.delete();
                break;
            }
            default: {
                throw new Exception("Method not supported temporarily");
            }
        }
        return builder.build();
    }

    private static RequestBody p_jsonBody(HttpRequest httpRequest) {
        String json = "";
        if (httpRequest.hasBodyParameter()) {
            json = JSON.toJSONString(httpRequest.getBodyParameter());
        }
        return RequestBody.create((String)json, (MediaType)MEDIA_TYPE_JSON);
    }

    private static FormBody p_formBody(HttpRequest httpRequest) {
        FormBody.Builder bodyBuilder = new FormBody.Builder();
        if (httpRequest.hasBodyParameter()) {
            httpRequest.getBodyParameter().forEach((arg_0, arg_1) -> ((FormBody.Builder)bodyBuilder).add(arg_0, arg_1));
        }
        return bodyBuilder.build();
    }

    private static RequestBody p_body(HttpRequest httpRequest) throws Exception {
        RequestBody body = null;
        switch (httpRequest.getRequestBodyMode()) {
            case RAW_JSON: {
                body = HttpUtils.p_jsonBody(httpRequest);
                break;
            }
            case FORM_DATA: {
                body = HttpUtils.p_formBody(httpRequest);
                break;
            }
            default: {
                throw new Exception("Unknown Request Body Mode!!!");
            }
        }
        return body;
    }

    private static HttpResponse p_errorResponse(HttpRequest httpRequest, Exception e) {
        HttpResponse response = new HttpResponse();
        response.setCode(-1);
        response.setHttpRequest(httpRequest);
        response.setBodyString(e.getMessage());
        response.setSuccess(false);
        return response;
    }
}

