/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.net.http;

import cn.buli_home.utils.common.StringUtils;
import cn.buli_home.utils.net.http.HttpMethod;
import cn.buli_home.utils.net.http.HttpRequestBodyMode;
import cn.buli_home.utils.net.http.HttpRequestMode;
import com.alibaba.fastjson2.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class HttpRequest {
    private String url;
    private HttpMethod method;
    private HttpRequestMode requestMode;
    private HttpRequestBodyMode requestBodyMode;
    private Map<String, String> header;
    private Map<String, String> queryParameter;
    private Map<String, String> bodyParameter;
    private boolean ignoreSSL;

    public void addHeader(String key, String value) {
        if (Objects.isNull(this.header)) {
            this.header = new HashMap<String, String>();
        }
        this.header.put(key, value);
    }

    public void addHeader(JSONObject jsonObject) {
        if (Objects.isNull(jsonObject)) {
            return;
        }
        jsonObject.forEach((k, v) -> this.addHeader((String)k, StringUtils.convert2String(v)));
    }

    public boolean hasHeader() {
        return Objects.nonNull(this.header) && !this.header.isEmpty();
    }

    public void addQueryParameter(String key, String value) {
        if (Objects.isNull(this.queryParameter)) {
            this.queryParameter = new HashMap<String, String>();
        }
        this.queryParameter.put(key, value);
    }

    public void addQueryParameter(JSONObject jsonObject) {
        if (Objects.isNull(jsonObject)) {
            return;
        }
        jsonObject.forEach((k, v) -> this.addQueryParameter((String)k, StringUtils.convert2String(v)));
    }

    public boolean hasQueryParameter() {
        return Objects.nonNull(this.queryParameter) && !this.queryParameter.isEmpty();
    }

    public void addBodyParameter(String key, String value) {
        if (Objects.isNull(this.bodyParameter)) {
            this.bodyParameter = new HashMap<String, String>();
        }
        this.bodyParameter.put(key, value);
    }

    public void addBodyParameter(JSONObject jsonObject) {
        if (Objects.isNull(jsonObject)) {
            return;
        }
        jsonObject.forEach((k, v) -> this.addBodyParameter((String)k, StringUtils.convert2String(v)));
    }

    public boolean hasBodyParameter() {
        return Objects.nonNull(this.bodyParameter) && !this.bodyParameter.isEmpty();
    }

    private HttpRequest() {
    }

    private HttpRequest(Builder builder) {
        if (StringUtils.isEmptyWithoutBlank(builder.url)) {
            throw new NullPointerException(builder.url);
        }
        this.url = builder.url;
        this.method = Objects.isNull((Object)builder.method) ? HttpMethod.GET : builder.method;
        this.requestMode = Objects.isNull((Object)builder.requestMode) ? HttpRequestMode.SYNCHRONOUS : builder.requestMode;
        this.requestBodyMode = Objects.isNull((Object)builder.requestBodyMode) ? HttpRequestBodyMode.FORM_DATA : builder.requestBodyMode;
    }

    public String getUrl() {
        return this.url;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public HttpRequestMode getRequestMode() {
        return this.requestMode;
    }

    public HttpRequestBodyMode getRequestBodyMode() {
        return this.requestBodyMode;
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    public Map<String, String> getQueryParameter() {
        return this.queryParameter;
    }

    public Map<String, String> getBodyParameter() {
        return this.bodyParameter;
    }

    public boolean isIgnoreSSL() {
        return this.ignoreSSL;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public void setRequestMode(HttpRequestMode requestMode) {
        this.requestMode = requestMode;
    }

    public void setRequestBodyMode(HttpRequestBodyMode requestBodyMode) {
        this.requestBodyMode = requestBodyMode;
    }

    public void setHeader(Map<String, String> header) {
        this.header = header;
    }

    public void setQueryParameter(Map<String, String> queryParameter) {
        this.queryParameter = queryParameter;
    }

    public void setBodyParameter(Map<String, String> bodyParameter) {
        this.bodyParameter = bodyParameter;
    }

    public void setIgnoreSSL(boolean ignoreSSL) {
        this.ignoreSSL = ignoreSSL;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isIgnoreSSL() != other.isIgnoreSSL()) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        HttpMethod this$method = this.getMethod();
        HttpMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        HttpRequestMode this$requestMode = this.getRequestMode();
        HttpRequestMode other$requestMode = other.getRequestMode();
        if (this$requestMode == null ? other$requestMode != null : !((Object)((Object)this$requestMode)).equals((Object)other$requestMode)) {
            return false;
        }
        HttpRequestBodyMode this$requestBodyMode = this.getRequestBodyMode();
        HttpRequestBodyMode other$requestBodyMode = other.getRequestBodyMode();
        if (this$requestBodyMode == null ? other$requestBodyMode != null : !((Object)((Object)this$requestBodyMode)).equals((Object)other$requestBodyMode)) {
            return false;
        }
        Map<String, String> this$header = this.getHeader();
        Map<String, String> other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        Map<String, String> this$queryParameter = this.getQueryParameter();
        Map<String, String> other$queryParameter = other.getQueryParameter();
        if (this$queryParameter == null ? other$queryParameter != null : !((Object)this$queryParameter).equals(other$queryParameter)) {
            return false;
        }
        Map<String, String> this$bodyParameter = this.getBodyParameter();
        Map<String, String> other$bodyParameter = other.getBodyParameter();
        return !(this$bodyParameter == null ? other$bodyParameter != null : !((Object)this$bodyParameter).equals(other$bodyParameter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIgnoreSSL() ? 79 : 97);
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        HttpMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        HttpRequestMode $requestMode = this.getRequestMode();
        result = result * 59 + ($requestMode == null ? 43 : ((Object)((Object)$requestMode)).hashCode());
        HttpRequestBodyMode $requestBodyMode = this.getRequestBodyMode();
        result = result * 59 + ($requestBodyMode == null ? 43 : ((Object)((Object)$requestBodyMode)).hashCode());
        Map<String, String> $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        Map<String, String> $queryParameter = this.getQueryParameter();
        result = result * 59 + ($queryParameter == null ? 43 : ((Object)$queryParameter).hashCode());
        Map<String, String> $bodyParameter = this.getBodyParameter();
        result = result * 59 + ($bodyParameter == null ? 43 : ((Object)$bodyParameter).hashCode());
        return result;
    }

    public String toString() {
        return "HttpRequest(url=" + this.getUrl() + ", method=" + (Object)((Object)this.getMethod()) + ", requestMode=" + (Object)((Object)this.getRequestMode()) + ", requestBodyMode=" + (Object)((Object)this.getRequestBodyMode()) + ", header=" + this.getHeader() + ", queryParameter=" + this.getQueryParameter() + ", bodyParameter=" + this.getBodyParameter() + ", ignoreSSL=" + this.isIgnoreSSL() + ")";
    }

    public static class Builder {
        private String url;
        private HttpMethod method;
        private HttpRequestMode requestMode;
        private HttpRequestBodyMode requestBodyMode;

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder requestMode(HttpRequestMode requestMode) {
            this.requestMode = requestMode;
            return this;
        }

        public Builder requestBodyMode(HttpRequestBodyMode requestBodyMode) {
            this.requestBodyMode = requestBodyMode;
            return this;
        }

        public HttpRequest build() {
            return new HttpRequest(this);
        }
    }
}

