/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.file;

import cn.buli_home.utils.file.IoCopier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class StreamCopier
extends IoCopier<InputStream, OutputStream> {
    public StreamCopier() {
        this(8192);
    }

    public StreamCopier(int bufferSize) {
        this(bufferSize, -1L);
    }

    public StreamCopier(int bufferSize, long count) {
        super(bufferSize, count);
    }

    @Override
    public long copy(InputStream source, OutputStream target) {
        long size;
        if (Objects.isNull(source)) {
            throw new RuntimeException("InputStream is null!");
        }
        if (Objects.isNull(target)) {
            throw new RuntimeException("OutputStream is null!");
        }
        try {
            size = this.doCopy(source, target, new byte[this.bufferSize(this.count)]);
            target.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return size;
    }

    private long doCopy(InputStream source, OutputStream target, byte[] buffer) throws IOException {
        int read;
        long numToRead = this.count > 0L ? this.count : Long.MAX_VALUE;
        long total = 0L;
        while (numToRead > 0L && (read = source.read(buffer, 0, this.bufferSize(numToRead))) >= 0) {
            target.write(buffer, 0, read);
            if (this.flushEveryBuffer) {
                target.flush();
            }
            numToRead -= (long)read;
            total += (long)read;
        }
        return total;
    }
}

