/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.file;

import cn.buli_home.utils.common.HexUtils;
import cn.buli_home.utils.file.FastByteArrayOutputStream;
import cn.buli_home.utils.file.StreamCopier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    public static String readHex64Upper(InputStream in) throws RuntimeException {
        return IOUtils.readHex(in, 64, false);
    }

    public static String readHex8192Upper(InputStream in) throws RuntimeException {
        try {
            int i = in.available();
            return IOUtils.readHex(in, Math.min(8192, in.available()), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readHex(InputStream in, int length, boolean toLowerCase) throws RuntimeException {
        return HexUtils.encodeHexStr(IOUtils.readBytes(in, length), toLowerCase);
    }

    public static byte[] readBytes(InputStream in, int length) throws RuntimeException {
        if (null == in) {
            return null;
        }
        if (length <= 0) {
            return new byte[0];
        }
        FastByteArrayOutputStream out = new FastByteArrayOutputStream(length);
        IOUtils.copy(in, out, 8192, length);
        return out.toByteArray();
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, long count) throws RuntimeException {
        return new StreamCopier(bufferSize, count).copy(in, out);
    }
}

