/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.file;

import cn.buli_home.utils.common.StringUtils;
import cn.buli_home.utils.constant.StringConstant;
import cn.buli_home.utils.file.CommonFileUtils;
import cn.buli_home.utils.file.FileWriteType;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FileUtils {
    private static final int BUFFER_SIZE = 1024;
    private static final String FILE_OPEN_MODE = "rw";
    public static final char UNIX_SEPARATOR = '/';
    public static final char WINDOWS_SEPARATOR = '\\';
    private static final CharSequence[] SPECIAL_SUFFIX = new CharSequence[]{"tar.bz2", "tar.Z", "tar.gz", "tar.xz"};

    public static List<Tuple2<Integer, String>> readFileByLine(File file) throws Exception {
        ArrayList<Tuple2<Integer, String>> resultList = new ArrayList<Tuple2<Integer, String>>();
        ByteBuffer rebuff = ByteBuffer.allocate(1024);
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        int lineIdx = 0;
        byte CF = "\n".getBytes()[0];
        byte[] temp = new byte[]{};
        while (fileChannel.read(rebuff) != -1) {
            byte[] rbyte = new byte[rebuff.position()];
            rebuff.flip();
            rebuff.get(rbyte);
            int startNum = 0;
            for (int i = 0; i < rbyte.length; ++i) {
                if (rbyte[i] != CF) continue;
                byte[] line = new byte[temp.length + i - startNum];
                System.arraycopy(temp, 0, line, 0, temp.length);
                System.arraycopy(rbyte, startNum, line, temp.length, i - startNum);
                startNum = i + 1;
                temp = new byte[]{};
                String lineStr = new String(line, StandardCharsets.UTF_8);
                resultList.add((Tuple2<Integer, String>)Tuple.of((Object)lineIdx, (Object)lineStr));
                ++lineIdx;
            }
            if (startNum < rbyte.length) {
                byte[] temp2 = new byte[temp.length + rbyte.length - startNum];
                System.arraycopy(temp, 0, temp2, 0, temp.length);
                System.arraycopy(rbyte, startNum, temp2, temp.length, rbyte.length - startNum);
                temp = temp2;
            }
            rebuff.clear();
        }
        if (temp.length > 0) {
            String lineStr = new String(temp, StandardCharsets.UTF_8);
            resultList.add((Tuple2<Integer, String>)Tuple.of((Object)lineIdx, (Object)lineStr));
        }
        fileChannel.close();
        return resultList;
    }

    @Deprecated
    public static void writeFile(String path, String content, boolean overwrite) throws Exception {
        Path oPath = Paths.get(path, new String[0]);
        boolean exists = Files.exists(oPath, new LinkOption[0]);
        if (exists) {
            if (!overwrite) {
                return;
            }
            Files.delete(oPath);
        }
        RandomAccessFile stream = new RandomAccessFile(path, FILE_OPEN_MODE);
        FileChannel channel = stream.getChannel();
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        buffer.put(bytes);
        buffer.flip();
        channel.write(buffer);
        channel.close();
        stream.close();
    }

    public static void writeFile(String path, String content, FileWriteType writeType) throws Exception {
        Path oPath = Paths.get(path, new String[0]);
        if (writeType == FileWriteType.ONCE && Files.exists(oPath, new LinkOption[0])) {
            return;
        }
        if (writeType == FileWriteType.OVERWRITE) {
            Files.delete(oPath);
        }
        RandomAccessFile raFile = new RandomAccessFile(path, FILE_OPEN_MODE);
        FileChannel channel = raFile.getChannel();
        String writeContent = content;
        if (writeType == FileWriteType.APPEND_NEWLINE && channel.size() != 0L) {
            writeContent = "\r\n".concat(content);
        }
        byte[] bytes = writeContent.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        channel.position(channel.size());
        buffer.clear();
        buffer.put(bytes);
        buffer.flip();
        while (buffer.hasRemaining()) {
            channel.write(buffer);
        }
        channel.close();
        raFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void writeFile(File file, String content, boolean overwrite) throws Exception {
        if (Objects.isNull(file)) {
            return;
        }
        OutputStreamWriter writer = null;
        try {
            writer = new FileWriter(file, !overwrite);
            writer.append(content);
            writer.flush();
        }
        finally {
            if (Objects.nonNull(writer)) {
                writer.close();
            }
        }
    }

    public static void writeFile(File file, String content, FileWriteType writeType) throws Exception {
        FileUtils.writeFile(file.getPath(), content, writeType);
    }

    public static String readFile(String path) throws Exception {
        boolean exists = CommonFileUtils.existsFile(path);
        if (!exists) {
            throw new FileNotFoundException();
        }
        RandomAccessFile raFile = new RandomAccessFile(path, FILE_OPEN_MODE);
        FileChannel channel = raFile.getChannel();
        ByteBuffer buf = ByteBuffer.allocate(1024);
        StringBuilder stringBuilder = new StringBuilder();
        int bytesRead = channel.read(buf);
        while (bytesRead != -1) {
            buf.flip();
            while (buf.hasRemaining()) {
                char tChar = (char)buf.get();
                if (tChar == '\r') continue;
                stringBuilder.append(tChar);
            }
            buf.clear();
            bytesRead = channel.read(buf);
        }
        channel.close();
        raFile.close();
        return stringBuilder.toString();
    }

    public static void createFolder(String path) throws IOException {
        if (FileUtils.folderExists(path)) {
            return;
        }
        Path iPath = Paths.get(path, new String[0]);
        Files.createDirectories(iPath, new FileAttribute[0]);
    }

    public static boolean folderExists(String path) {
        File file = new File(path);
        return file.exists() && file.isDirectory();
    }

    public static boolean fileExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static boolean renameFile(String oldPath, String newPath) {
        File file = new File(oldPath);
        if (!file.exists()) {
            return false;
        }
        return file.renameTo(new File(newPath));
    }

    public static String extName(String fileName) {
        if (StringUtils.isEmpty(fileName)) {
            return "";
        }
        int idx = fileName.lastIndexOf(StringConstant.DOT);
        if (idx < 0) {
            return "";
        }
        int secondToLastIndex = fileName.substring(0, idx).lastIndexOf(StringConstant.DOT);
        String subStr = fileName.substring(secondToLastIndex == -1 ? idx : secondToLastIndex + 1);
        if (StringUtils.containsAny(subStr, SPECIAL_SUFFIX)) {
            return subStr;
        }
        String ext = fileName.substring(idx + 1);
        return StringUtils.containsAnyChar(ext, '/', '\\') != false ? "" : ext;
    }

    public static String extName(File file) {
        if (Objects.isNull(file)) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        return FileUtils.extName(file.getName());
    }
}

