/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.file;

import cn.buli_home.utils.common.HexUtils;
import cn.buli_home.utils.common.MapUtils;
import cn.buli_home.utils.common.StringUtils;
import cn.buli_home.utils.file.FileMagicNumber;
import cn.buli_home.utils.file.FileUtils;
import cn.buli_home.utils.file.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentSkipListMap;

public class FileTypeUtils {
    private static final Map<String, String> FILE_TYPE_MAP = new ConcurrentSkipListMap<String, String>();

    public static String putFileType(String fileStreamHexHead, String extName) {
        return FILE_TYPE_MAP.put(fileStreamHexHead, extName);
    }

    public static String removeFileType(String fileStreamHexHead) {
        return FILE_TYPE_MAP.remove(fileStreamHexHead);
    }

    public static String getType(String fileStreamHexHead) {
        if (!MapUtils.isEmpty(FILE_TYPE_MAP)) {
            for (Map.Entry<String, String> fileTypeEntry : FILE_TYPE_MAP.entrySet()) {
                if (!StringUtils.startWithIgnoreCase(fileStreamHexHead, fileTypeEntry.getKey())) continue;
                return fileTypeEntry.getValue();
            }
        }
        byte[] bytes = HexUtils.decodeHex(fileStreamHexHead);
        return FileMagicNumber.getMagicNumber(bytes).getExtension();
    }

    public static String getType(InputStream in, int fileHeadSize) throws RuntimeException {
        return FileTypeUtils.getType(IOUtils.readHex(in, fileHeadSize, false));
    }

    public static String getType(InputStream in, boolean isExact) throws RuntimeException {
        if (null == in) {
            return null;
        }
        return isExact ? FileTypeUtils.getType(IOUtils.readHex8192Upper(in)) : FileTypeUtils.getType(IOUtils.readHex64Upper(in));
    }

    public static String getType(InputStream in) throws RuntimeException {
        return FileTypeUtils.getType(in, false);
    }

    public static String getType(InputStream in, String filename) throws RuntimeException {
        return FileTypeUtils.getType(in, filename, false);
    }

    public static String getType(InputStream in, String filename, boolean isExact) throws RuntimeException {
        String typeName = FileTypeUtils.getType(in, isExact);
        if (null == typeName) {
            typeName = FileUtils.extName(filename);
        } else if ("zip".equals(typeName)) {
            String extName = FileUtils.extName(filename);
            if ("docx".equalsIgnoreCase(extName)) {
                typeName = "docx";
            } else if ("xlsx".equalsIgnoreCase(extName)) {
                typeName = "xlsx";
            } else if ("pptx".equalsIgnoreCase(extName)) {
                typeName = "pptx";
            } else if ("jar".equalsIgnoreCase(extName)) {
                typeName = "jar";
            } else if ("war".equalsIgnoreCase(extName)) {
                typeName = "war";
            } else if ("ofd".equalsIgnoreCase(extName)) {
                typeName = "ofd";
            } else if ("apk".equalsIgnoreCase(extName)) {
                typeName = "apk";
            }
        } else if ("jar".equals(typeName)) {
            String extName = FileUtils.extName(filename);
            if ("xlsx".equalsIgnoreCase(extName)) {
                typeName = "xlsx";
            } else if ("docx".equalsIgnoreCase(extName)) {
                typeName = "docx";
            } else if ("pptx".equalsIgnoreCase(extName)) {
                typeName = "pptx";
            } else if ("zip".equalsIgnoreCase(extName)) {
                typeName = "zip";
            } else if ("apk".equalsIgnoreCase(extName)) {
                typeName = "apk";
            }
        }
        return typeName;
    }

    public static String getType(File file, boolean isExact) throws RuntimeException {
        if (Objects.isNull(file) || !file.isFile()) {
            throw new IllegalArgumentException("Not a regular file!");
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            String string = FileTypeUtils.getType(in, file.getName(), isExact);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (Objects.nonNull(in)) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String getType(File file) throws RuntimeException {
        return FileTypeUtils.getType(file, false);
    }

    public static String getTypeByPath(String path, boolean isExact) throws RuntimeException {
        return FileTypeUtils.getType(new File(path), isExact);
    }

    public static String getTypeByPath(String path) throws RuntimeException {
        return FileTypeUtils.getTypeByPath(path, false);
    }
}

