/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.file;

import cn.buli_home.utils.constant.StringConstant;
import cn.buli_home.utils.file.FileConstant;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

public class CommonFileUtils {
    public static String generateHandleFileName(String name, boolean haveDate, boolean canExtend) {
        String path = FileConstant.RESULT_PATH_PREFIX + name;
        if (haveDate) {
            SimpleDateFormat tempDate = new SimpleDateFormat("yyyyMMdd");
            String datetime = tempDate.format(new Date());
            path = path + StringConstant.UNDERLINE + datetime;
        }
        if (!canExtend) {
            return path + ".txt";
        }
        Path oPath = Paths.get(path + ".txt", new String[0]);
        boolean exists = Files.exists(oPath, new LinkOption[0]);
        if (exists) {
            int idx = 1;
            while (exists) {
                oPath = Paths.get(path + StringConstant.UNDERLINE + idx + ".txt", new String[0]);
                exists = Files.exists(oPath, new LinkOption[0]);
                ++idx;
            }
            return oPath.toString();
        }
        return path + ".txt";
    }

    public static String generateHandleFileName(String name, boolean canExtend) {
        return CommonFileUtils.generateHandleFileName(name, true, canExtend);
    }

    public static boolean existsFolder(String path) {
        if (Objects.isNull(path)) {
            return false;
        }
        File folder = new File(path);
        return folder.exists() && folder.isDirectory();
    }

    public static boolean existsFile(String path) {
        if (Objects.isNull(path)) {
            return false;
        }
        File file = new File(path);
        return file.exists() && !file.isDirectory();
    }

    public static boolean createFolder(String path) {
        if (Objects.isNull(path)) {
            return false;
        }
        boolean exists = CommonFileUtils.existsFolder(path);
        if (!exists) {
            File folder = new File(path);
            return folder.mkdirs();
        }
        return true;
    }

    public static boolean createFile(String path, boolean overwrite) throws IOException {
        if (Objects.isNull(path)) {
            return false;
        }
        File file = new File(path);
        if (file.exists() && !file.isDirectory()) {
            if (overwrite) {
                return file.createNewFile();
            }
            return true;
        }
        return file.createNewFile();
    }
}

