/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.excel;

import cn.buli_home.utils.excel.ExcelDataCallback;
import cn.buli_home.utils.excel.ExcelDataListener;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExcelUtils {
    private static final int WRITE_BATCH_COUNT = 3000;

    public static <T> void read(String filePath, int sheetNo, Class<T> clazz, ExcelDataCallback<T> callback) {
        ExcelUtils.read(filePath, sheetNo, clazz, 1, callback);
    }

    public static <T> void read(InputStream in, int sheetNo, Class<T> clazz, ExcelDataCallback<T> callback) {
        ExcelUtils.read(in, sheetNo, clazz, 1, callback);
    }

    public static <T> void read(String filePath, int sheetNo, Class<T> clazz, int headRowCount, ExcelDataCallback<T> callback) {
        ExcelDataListener<T> dataListener = new ExcelDataListener<T>(callback);
        ((ExcelReaderSheetBuilder)EasyExcel.read((String)filePath, clazz, dataListener).sheet(Integer.valueOf(sheetNo)).headRowNumber(Integer.valueOf(headRowCount))).doRead();
    }

    public static <T> void read(InputStream in, int sheetNo, Class<T> clazz, int headRowCount, ExcelDataCallback<T> callback) {
        ExcelDataListener<T> dataListener = new ExcelDataListener<T>(callback);
        ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)in, clazz, dataListener).sheet(Integer.valueOf(sheetNo)).headRowNumber(Integer.valueOf(headRowCount))).doRead();
    }

    public static <T> List<T> readSync(String filePath, int sheetNo, Class<T> clazz) {
        return ExcelUtils.readSync(filePath, sheetNo, clazz, 1);
    }

    public static <T> List<T> readSync(InputStream in, int sheetNo, Class<T> clazz) {
        return ExcelUtils.readSync(in, sheetNo, clazz, 1);
    }

    public static <T> List<T> readSync(String filePath, int sheetNo, Class<T> clazz, int headRowCount) {
        ExcelDataListener dataListener = new ExcelDataListener();
        return ((ExcelReaderSheetBuilder)EasyExcel.read((String)filePath, clazz, dataListener).sheet(Integer.valueOf(sheetNo)).headRowNumber(Integer.valueOf(headRowCount))).doReadSync();
    }

    public static <T> List<T> readSync(InputStream in, int sheetNo, Class<T> clazz, int headRowCount) {
        ExcelDataListener dataListener = new ExcelDataListener();
        return ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)in, clazz, dataListener).sheet(Integer.valueOf(sheetNo)).headRowNumber(Integer.valueOf(headRowCount))).doReadSync();
    }

    public static <T> void fillOnce(String filePath, String templatePath, int sheetNo, List<T> data) {
        EasyExcel.write((String)filePath).withTemplate(templatePath).sheet(Integer.valueOf(sheetNo)).doFill(data);
    }

    public static <T> void fill(String filePath, String templatePath, int sheetNo, List<T> data) {
        try (ExcelWriter excelWriter = EasyExcel.write((String)filePath).withTemplate(templatePath).build();){
            ExcelUtils.p_fill(excelWriter, sheetNo, data);
        }
    }

    public static <T> void fillOnce(OutputStream os, InputStream templateIS, int sheetNo, List<T> data) {
        EasyExcel.write((OutputStream)os).withTemplate(templateIS).sheet(Integer.valueOf(sheetNo)).doFill(data);
    }

    public static <T> void fill(OutputStream os, InputStream templateIS, int sheetNo, List<T> data) {
        try (ExcelWriter excelWriter = EasyExcel.write((OutputStream)os).withTemplate(templateIS).build();){
            ExcelUtils.p_fill(excelWriter, sheetNo, data);
        }
    }

    private static <T> void p_fill(ExcelWriter excelWriter, int sheetNo, List<T> data) {
        WriteSheet sheet = EasyExcel.writerSheet((Integer)sheetNo).build();
        int limit = (data.size() + 3000 - 1) / 3000;
        Stream.iterate(0, n -> n + 1).limit(limit).forEach(i -> {
            List writeList = data.stream().skip(i * 3000).limit(3000L).collect(Collectors.toList());
            excelWriter.fill(writeList, sheet);
        });
    }
}

