/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.excel;

import cn.buli_home.utils.excel.ExcelDataCallback;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.util.ListUtils;
import java.util.List;
import java.util.Objects;

public class ExcelDataListener<T>
extends AnalysisEventListener<T> {
    private static final int BATCH_COUNT = 3000;
    private List<T> cachedDataList = ListUtils.newArrayListWithExpectedSize((int)3000);
    private ExcelDataCallback<T> callback;

    public ExcelDataListener() {
    }

    public ExcelDataListener(ExcelDataCallback<T> callback) {
        this.callback = callback;
    }

    public void invoke(T data, AnalysisContext context) {
        this.cachedDataList.add(data);
        if (this.cachedDataList.size() >= 3000) {
            if (Objects.nonNull(this.callback)) {
                this.callback.invoke(this.cachedDataList);
            }
            this.cachedDataList = ListUtils.newArrayListWithExpectedSize((int)3000);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        if (Objects.nonNull(this.callback)) {
            this.callback.invoke(this.cachedDataList);
            this.callback.finish();
        }
        this.cachedDataList = ListUtils.newArrayListWithExpectedSize((int)3000);
    }
}

