/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.common;

import cn.buli_home.utils.common.ArrayUtils;
import cn.buli_home.utils.common.StringFormatter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class StringUtils {
    public static boolean isEmpty(CharSequence str) {
        return Objects.isNull(str) || str.length() == 0;
    }

    public static boolean isEmptyWithoutBlank(String str) {
        return StringUtils.isEmpty(StringUtils.replaceBlank(str));
    }

    public static String replaceBlank(CharSequence str) {
        return StringUtils.replace(str.toString(), "\\s*|\t|\r|\n|&nbsp;");
    }

    public static String replace(String str, String pattern) {
        if (StringUtils.isEmpty(str)) {
            return "";
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(str);
        return m.replaceAll("");
    }

    public static String replaceTemplate(String template, Map<String, Object> params) {
        return StringUtils.replaceTemplate(template, params, null);
    }

    public static String replaceTemplate(String template, Map<String, Object> params, List<String> excludes) {
        if (Objects.isNull(template) || Objects.isNull(params)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = Pattern.compile("\\$\\{\\w+\\}").matcher(template);
        while (m.find()) {
            String param = m.group();
            String content = param.substring(2, param.length() - 1);
            if (Objects.nonNull(excludes) && excludes.contains(content)) continue;
            Object value = params.get(content);
            m.appendReplacement(sb, Matcher.quoteReplacement(value == null ? "" : value.toString()));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String replaceLastChar(String str, char c, char r) {
        int lastIdx = str.lastIndexOf(c);
        if (lastIdx >= 0) {
            StringBuilder sb = new StringBuilder(str);
            sb.setCharAt(lastIdx, r);
            return sb.toString();
        }
        return str;
    }

    public static String replace(CharSequence str, int startInclude, int endExclude, CharSequence replacedStr) {
        int i;
        if (StringUtils.isEmpty(str)) {
            return StringUtils.convert2String(str);
        }
        String originalStr = StringUtils.convert2String(str);
        int[] strCodePoints = originalStr.codePoints().toArray();
        int strLength = strCodePoints.length;
        if (startInclude > strLength) {
            return originalStr;
        }
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (startInclude > endExclude) {
            return originalStr;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (i = 0; i < startInclude; ++i) {
            stringBuilder.append(new String(strCodePoints, i, 1));
        }
        stringBuilder.append(replacedStr);
        for (i = endExclude; i < strLength; ++i) {
            stringBuilder.append(new String(strCodePoints, i, 1));
        }
        return stringBuilder.toString();
    }

    public static String format(CharSequence template, Object ... params) {
        if (StringUtils.isEmpty(template)) {
            return "";
        }
        if (ArrayUtils.isEmpty(params)) {
            return template.toString();
        }
        return StringFormatter.format(template.toString(), params);
    }

    public static String hide(CharSequence str, int startInclude, int endExclude) {
        return StringUtils.replace(str, startInclude, endExclude, "*");
    }

    public static String convert2String(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            if (((String)obj).equalsIgnoreCase("null") || ((String)obj).equalsIgnoreCase("<null>")) {
                return "";
            }
            return (String)obj;
        }
        return obj.toString();
    }

    public static String convert2StringOrNull(Object obj) {
        return Objects.isNull(obj) ? null : StringUtils.convert2String(obj);
    }

    public static String upperFirst(String str) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!Character.isLetter(c)) continue;
            chars[i] = StringUtils.p_upperChar(c);
            break;
        }
        return String.valueOf(chars);
    }

    public static String lowerFirst(String str) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!Character.isLetter(c)) continue;
            chars[i] = StringUtils.p_lowerChar(c);
            break;
        }
        return String.valueOf(chars);
    }

    public static String camel2Underline(String str) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch >= 'A' && ch <= 'Z') {
                char ch_ucase = StringUtils.p_lowerChar(ch);
                if (i > 0) {
                    buf.append('_');
                }
                buf.append(ch_ucase);
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String underline2Camel(String str) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        String[] split = str.split("_");
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            if (i == 0) {
                sb.append(s);
                continue;
            }
            sb.append(StringUtils.upperFirst(s));
        }
        return sb.toString();
    }

    public static String removePrefix(String str, String[] prefix) {
        if (Objects.isNull(str) || str.length() == 0) {
            return "";
        }
        if (null != prefix) {
            String[] prefixArray = prefix;
            for (int i = 0; i < prefix.length; ++i) {
                String pf = prefixArray[i];
                if (!str.toLowerCase().matches("^" + pf.toLowerCase() + ".*")) continue;
                return str.substring(pf.length());
            }
        }
        return str;
    }

    @Deprecated
    public static Integer parseInt(String str) {
        String tmpStr = StringUtils.convert2String(str);
        if (tmpStr.equals("")) {
            return 0;
        }
        int n = 0;
        try {
            n = (int)Double.parseDouble(tmpStr);
        }
        catch (Exception e) {
            return 0;
        }
        return n;
    }

    @Deprecated
    public static Long parseLong(String str) {
        String tmpStr = StringUtils.convert2String(str);
        if (tmpStr.equals("")) {
            return 0L;
        }
        long n = 0L;
        try {
            n = Long.parseLong(tmpStr);
        }
        catch (Exception e) {
            return 0L;
        }
        return n;
    }

    @Deprecated
    public static Double parseDouble(String str) {
        String tmpStr = StringUtils.convert2String(str);
        if (tmpStr.equals("")) {
            return 0.0;
        }
        double n = 0.0;
        try {
            n = Double.parseDouble(tmpStr);
        }
        catch (Exception e) {
            return 0.0;
        }
        return n;
    }

    public static Boolean parseBoolean(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        return str.equalsIgnoreCase("true") || str.equalsIgnoreCase("yes") || str.equalsIgnoreCase("success");
    }

    public static String getSplitAtIdx(String str, String regex, int idx) {
        String string = StringUtils.convert2String(str);
        String[] array = string.split(regex);
        if (array.length > idx) {
            return array[idx];
        }
        return "";
    }

    public static boolean hasSpecialChar(String str) {
        Pattern p = Pattern.compile("[ _`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]|\n|\r|\t");
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static String utf8Str(Object obj) {
        return StringUtils.str(obj, StandardCharsets.UTF_8);
    }

    @Deprecated
    public static String str(Object obj, String charsetName) {
        return StringUtils.str(obj, Charset.forName(charsetName));
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StringUtils.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StringUtils.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StringUtils.str((ByteBuffer)obj, charset);
        }
        if (ArrayUtils.isArray(obj)) {
            return ArrayUtils.toString(obj);
        }
        return obj.toString();
    }

    public static String str(byte[] bytes, String charset) {
        return StringUtils.str(bytes, Charset.forName(charset));
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(Byte[] bytes, String charset) {
        return StringUtils.str(bytes, Charset.forName(charset));
    }

    public static String str(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return StringUtils.str(bytes, charset);
    }

    public static String str(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        return StringUtils.str(data, Charset.forName(charset));
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static int bytesLength(String str) {
        return StringUtils.convert2String(str).getBytes().length;
    }

    public static String base64(String str) {
        return Base64.encodeBase64String((byte[])StringUtils.convert2String(str).getBytes(StandardCharsets.UTF_8));
    }

    public static String md5(String str) {
        return StringUtils.hash(str, "MD5");
    }

    public static String sha1(String str) {
        return StringUtils.hash(str, "SHA-1");
    }

    public static String sha256(String str) {
        return StringUtils.hash(str, "SHA-256");
    }

    public static String sha512(String str) {
        return StringUtils.hash(str, "SHA-512");
    }

    public static String hash(String str, String type) {
        try {
            MessageDigest digest = MessageDigest.getInstance(type);
            return Hex.encodeHexString((byte[])digest.digest(StringUtils.convert2String(str).getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Boolean containsAnyChar(String str, char ... chars) {
        if (!StringUtils.isEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (!ArrayUtils.contains(chars, str.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(CharSequence str, CharSequence ... testStrs) {
        return null != StringUtils.getContainsStr(str, testStrs);
    }

    public static String getContainsStr(CharSequence str, CharSequence ... testStrs) {
        if (StringUtils.isEmpty(str) || ArrayUtils.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence checkStr : testStrs) {
            if (null == checkStr || !str.toString().contains(checkStr)) continue;
            return checkStr.toString();
        }
        return null;
    }

    public static Boolean hasRegex(String str, String regex) {
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(str).find();
    }

    public static Boolean onlyRegex(String str, String regex) {
        return Pattern.matches(regex, str);
    }

    public static String findRegexFirst(String str, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public static List<String> findRegexList(String str, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            list.add(matcher.group());
        }
        return list;
    }

    public static int specifiedSymbolCount(String str, String symbol) {
        return (str.length() - str.replace(symbol, "").length()) / symbol.length();
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean isIgnoreCase, boolean isIgnoreEquals) {
        String p;
        if (Objects.isNull(str) || Objects.isNull(prefix)) {
            return !isIgnoreEquals;
        }
        String s = str.toString();
        boolean isStartWith = s.regionMatches(isIgnoreCase, 0, p = prefix.toString(), 0, prefix.length());
        if (isStartWith) {
            return !isIgnoreEquals || s.equalsIgnoreCase(p);
        }
        return false;
    }

    public static boolean startWithIgnoreCase(CharSequence str, CharSequence prefix) {
        return StringUtils.startWith(str, prefix, true, false);
    }

    private static char p_upperChar(char c) {
        if (c >= 'a') {
            c = (char)(c - 32);
        }
        return c;
    }

    private static char p_lowerChar(char c) {
        if (c < 'a') {
            c = (char)(c + 32);
        }
        return c;
    }
}

