/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.common;

import cn.buli_home.utils.common.ArrayUtils;
import cn.buli_home.utils.common.ListUtils;
import cn.buli_home.utils.common.NumberUtils;
import cn.buli_home.utils.common.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class RandomUtils {
    public static final String BASE_NUMBER = "0123456789";
    public static final String BASE_CHAR = "abcdefghijklmnopqrstuvwxyz";
    public static final String BASE_CHAR_NUMBER_LOWER = "abcdefghijklmnopqrstuvwxyz0123456789";
    public static final String BASE_CHAR_NUMBER = "abcdefghijklmnopqrstuvwxyz".toUpperCase() + "abcdefghijklmnopqrstuvwxyz0123456789";

    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static SecureRandom createSecureRandom(byte[] seed) {
        return null == seed ? new SecureRandom() : new SecureRandom(seed);
    }

    public static SecureRandom getSecureRandom() {
        return RandomUtils.getSecureRandom(null);
    }

    public static SecureRandom getSecureRandom(byte[] seed) {
        return RandomUtils.createSecureRandom(seed);
    }

    public static Random getRandom(boolean isSecure) {
        return isSecure ? RandomUtils.getSecureRandom() : RandomUtils.getRandom();
    }

    public static boolean randomBoolean() {
        return 0 == RandomUtils.randomInt(2);
    }

    public static byte[] randomBytes(int length) {
        byte[] bytes = new byte[length];
        RandomUtils.getRandom().nextBytes(bytes);
        return bytes;
    }

    public static int randomInt() {
        return RandomUtils.getRandom().nextInt();
    }

    public static int randomInt(int limitExclude) {
        return RandomUtils.getRandom().nextInt(limitExclude);
    }

    public static int randomInt(int minInclude, int maxExclude) {
        return RandomUtils.randomInt(minInclude, maxExclude, true, false);
    }

    public static int randomInt(int min, int max, boolean includeMin, boolean includeMax) {
        if (!includeMin) {
            ++min;
        }
        if (includeMax) {
            ++max;
        }
        return RandomUtils.getRandom().nextInt(min, max);
    }

    public static int[] randomInts(int length) {
        int[] range = ArrayUtils.range(length);
        for (int i = 0; i < length; ++i) {
            int random = RandomUtils.randomInt(i, length);
            ArrayUtils.swap(range, i, random);
        }
        return range;
    }

    public static long randomLong() {
        return RandomUtils.getRandom().nextLong();
    }

    public static long randomLong(long limitExclude) {
        return RandomUtils.getRandom().nextLong(limitExclude);
    }

    public static long randomLong(long minInclude, long maxExclude) {
        return RandomUtils.randomLong(minInclude, maxExclude, true, false);
    }

    public static long randomLong(long min, long max, boolean includeMin, boolean includeMax) {
        if (!includeMin) {
            ++min;
        }
        if (includeMax) {
            ++max;
        }
        return RandomUtils.getRandom().nextLong(min, max);
    }

    public static float randomFloat() {
        return RandomUtils.getRandom().nextFloat();
    }

    public static float randomFloat(float limitExclude) {
        return RandomUtils.randomFloat(0.0f, limitExclude);
    }

    public static float randomFloat(float minInclude, float maxExclude) {
        if (minInclude == maxExclude) {
            return minInclude;
        }
        return minInclude + (maxExclude - minInclude) * RandomUtils.getRandom().nextFloat();
    }

    public static double randomDouble(double minInclude, double maxExclude) {
        return RandomUtils.getRandom().nextDouble(minInclude, maxExclude);
    }

    public static double randomDouble(double minInclude, double maxExclude, int scale, RoundingMode roundingMode) {
        return NumberUtils.round(RandomUtils.randomDouble(minInclude, maxExclude), scale, roundingMode).doubleValue();
    }

    public static double randomDouble() {
        return RandomUtils.getRandom().nextDouble();
    }

    public static double randomDouble(int scale, RoundingMode roundingMode) {
        return NumberUtils.round(RandomUtils.randomDouble(), scale, roundingMode).doubleValue();
    }

    public static double randomDouble(double limit) {
        return RandomUtils.getRandom().nextDouble(limit);
    }

    public static double randomDouble(double limit, int scale, RoundingMode roundingMode) {
        return NumberUtils.round(RandomUtils.randomDouble(limit), scale, roundingMode).doubleValue();
    }

    public static BigDecimal randomBigDecimal() {
        return NumberUtils.toBigDecimal(RandomUtils.getRandom().nextDouble());
    }

    public static BigDecimal randomBigDecimal(BigDecimal limit) {
        return NumberUtils.toBigDecimal(RandomUtils.getRandom().nextDouble(limit.doubleValue()));
    }

    public static BigDecimal randomBigDecimal(BigDecimal minInclude, BigDecimal maxExclude) {
        return NumberUtils.toBigDecimal(RandomUtils.getRandom().nextDouble(minInclude.doubleValue(), maxExclude.doubleValue()));
    }

    public static <T> T randomEle(List<T> list) {
        return RandomUtils.randomEle(list, list.size());
    }

    public static <T> T randomEle(List<T> list, int limit) {
        if (list.size() < limit) {
            limit = list.size();
        }
        return list.get(RandomUtils.randomInt(limit));
    }

    public static <T> T randomEle(T[] array) {
        return RandomUtils.randomEle(array, array.length);
    }

    public static <T> T randomEle(T[] array, int limit) {
        if (array.length < limit) {
            limit = array.length;
        }
        return array[RandomUtils.randomInt(limit)];
    }

    public static <T> List<T> randomEles(List<T> list, int count) {
        ArrayList<T> result = new ArrayList<T>(count);
        int limit = list.size();
        while (result.size() < count) {
            result.add(RandomUtils.randomEle(list, limit));
        }
        return result;
    }

    public static <T> List<T> randomEleList(List<T> source, int count) {
        if (count >= source.size()) {
            return ListUtils.toList(source);
        }
        int[] randomList = ArrayUtils.sub(RandomUtils.randomInts(source.size()), 0, count);
        ArrayList<T> result = new ArrayList<T>();
        for (int e : randomList) {
            result.add(source.get(e));
        }
        return result;
    }

    public static String randomString(int length) {
        return RandomUtils.randomString(BASE_CHAR_NUMBER, length);
    }

    public static String randomStringUpper(int length) {
        return RandomUtils.randomString(BASE_CHAR_NUMBER, length).toUpperCase();
    }

    public static String randomNumbers(int length) {
        return RandomUtils.randomString(BASE_NUMBER, length);
    }

    public static String randomString(String baseString, int length) {
        if (StringUtils.isEmpty(baseString)) {
            return "";
        }
        if (length < 1) {
            length = 1;
        }
        StringBuilder sb = new StringBuilder(length);
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = RandomUtils.randomInt(baseLength);
            sb.append(baseString.charAt(number));
        }
        return sb.toString();
    }

    public static char randomChinese() {
        return (char)RandomUtils.randomInt(19968, 40959);
    }

    public static char randomNumber() {
        return RandomUtils.randomChar(BASE_NUMBER);
    }

    public static char randomChar() {
        return RandomUtils.randomChar(BASE_CHAR_NUMBER);
    }

    public static char randomChar(String baseString) {
        return baseString.charAt(RandomUtils.randomInt(baseString.length()));
    }
}

