/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.common;

import cn.buli_home.utils.common.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Objects;

public class NumberUtils {
    public static boolean isValidNumber(Number number) {
        if (null == number) {
            return false;
        }
        if (number instanceof Double) {
            return !((Double)number).isInfinite() && !((Double)number).isNaN();
        }
        if (number instanceof Float) {
            return !((Float)number).isInfinite() && !((Float)number).isNaN();
        }
        return true;
    }

    public static boolean isValid(double number) {
        return !Double.isNaN(number) && !Double.isInfinite(number);
    }

    public static boolean isValid(float number) {
        return !Float.isNaN(number) && !Float.isInfinite(number);
    }

    public static boolean equals(double num1, double num2) {
        return Double.doubleToLongBits(num1) == Double.doubleToLongBits(num2);
    }

    public static boolean equals(float num1, float num2) {
        return Float.floatToIntBits(num1) == Float.floatToIntBits(num2);
    }

    public static boolean equals(long num1, long num2) {
        return num1 == num2;
    }

    public static boolean equals(Number number1, Number number2) {
        if (number1 instanceof BigDecimal && number2 instanceof BigDecimal) {
            return NumberUtils.equals((BigDecimal)number1, (BigDecimal)number2);
        }
        return Objects.equals(number1, number2);
    }

    public static boolean equals(BigDecimal bigNum1, BigDecimal bigNum2) {
        if (bigNum1 == bigNum2) {
            return true;
        }
        if (bigNum1 == null || bigNum2 == null) {
            return false;
        }
        return 0 == bigNum1.compareTo(bigNum2);
    }

    public static BigDecimal round(double v, int scale) {
        return NumberUtils.round(v, scale, RoundingMode.HALF_UP);
    }

    public static String roundStr(double v, int scale) {
        return NumberUtils.round(v, scale).toPlainString();
    }

    public static BigDecimal round(String numberStr, int scale) {
        return NumberUtils.round(numberStr, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal round(BigDecimal number, int scale) {
        return NumberUtils.round(number, scale, RoundingMode.HALF_UP);
    }

    public static String roundStr(String numberStr, int scale) {
        return NumberUtils.round(numberStr, scale).toPlainString();
    }

    public static BigDecimal round(double v, int scale, RoundingMode roundingMode) {
        return NumberUtils.round(Double.toString(v), scale, roundingMode);
    }

    public static String roundStr(double v, int scale, RoundingMode roundingMode) {
        return NumberUtils.round(v, scale, roundingMode).toPlainString();
    }

    public static BigDecimal round(String numberStr, int scale, RoundingMode roundingMode) {
        if (StringUtils.isEmpty(numberStr)) {
            throw new RuntimeException("number cannot be null!");
        }
        if (scale < 0) {
            scale = 0;
        }
        return NumberUtils.round(NumberUtils.toBigDecimal(numberStr), scale, roundingMode);
    }

    public static BigDecimal round(BigDecimal number, int scale, RoundingMode roundingMode) {
        if (null == number) {
            number = BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = 0;
        }
        if (null == roundingMode) {
            roundingMode = RoundingMode.HALF_UP;
        }
        return number.setScale(scale, roundingMode);
    }

    public static String roundStr(String numberStr, int scale, RoundingMode roundingMode) {
        return NumberUtils.round(numberStr, scale, roundingMode).toPlainString();
    }

    public static BigDecimal roundHalfEven(Number number, int scale) {
        return NumberUtils.roundHalfEven(NumberUtils.toBigDecimal(number), scale);
    }

    public static BigDecimal roundHalfEven(BigDecimal value, int scale) {
        return NumberUtils.round(value, scale, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal roundDown(Number number, int scale) {
        return NumberUtils.roundDown(NumberUtils.toBigDecimal(number), scale);
    }

    public static BigDecimal roundDown(BigDecimal value, int scale) {
        return NumberUtils.round(value, scale, RoundingMode.DOWN);
    }

    public static BigDecimal toBigDecimal(Number number) {
        if (null == number) {
            return BigDecimal.ZERO;
        }
        if (!NumberUtils.isValidNumber(number)) {
            throw new RuntimeException("Number is invalid!");
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Long) {
            return new BigDecimal((Long)number);
        }
        if (number instanceof Integer) {
            return new BigDecimal((Integer)number);
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return new BigDecimal(number.toString());
    }

    public static BigDecimal toBigDecimal(String numberStr) {
        if (StringUtils.isEmpty(numberStr)) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(numberStr);
        }
        catch (Exception exception) {
            Number number = NumberUtils.parseNumber(numberStr);
            return NumberUtils.toBigDecimal(number);
        }
    }

    public static BigInteger toBigInteger(Number number) {
        if (null == number) {
            return BigInteger.ZERO;
        }
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof Long) {
            return BigInteger.valueOf((Long)number);
        }
        if (!NumberUtils.isValidNumber(number)) {
            throw new RuntimeException("Number is invalid!");
        }
        return NumberUtils.toBigInteger(number.longValue());
    }

    public static BigInteger toBigInteger(String number) {
        return StringUtils.isEmpty(number) ? BigInteger.ZERO : new BigInteger(number);
    }

    public static int parseInt(String number) throws NumberFormatException {
        if (StringUtils.isEmpty(number)) {
            return 0;
        }
        if (number.startsWith("0x") || number.startsWith("0X")) {
            return Integer.parseInt(number.substring(2), 16);
        }
        if (number.contains("e") || number.contains("E")) {
            throw new NumberFormatException("Unsupported int format: [{" + number + "}]");
        }
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return NumberUtils.parseNumber(number).intValue();
        }
    }

    public static long parseLong(String number) {
        if (StringUtils.isEmpty(number)) {
            return 0L;
        }
        if (number.startsWith("0x")) {
            return Long.parseLong(number.substring(2), 16);
        }
        try {
            return Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            return NumberUtils.parseNumber(number).longValue();
        }
    }

    public static float parseFloat(String number) {
        if (StringUtils.isEmpty(number)) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(number);
        }
        catch (NumberFormatException e) {
            return NumberUtils.parseNumber(number).floatValue();
        }
    }

    public static double parseDouble(String number) {
        if (StringUtils.isEmpty(number)) {
            return 0.0;
        }
        try {
            return Double.parseDouble(number);
        }
        catch (NumberFormatException e) {
            return NumberUtils.parseNumber(number).doubleValue();
        }
    }

    public static Number parseNumber(String numberStr) throws NumberFormatException {
        if (numberStr.startsWith("0x") || numberStr.startsWith("0X")) {
            return Long.parseLong(numberStr.substring(2), 16);
        }
        try {
            NumberFormat format = NumberFormat.getInstance();
            if (format instanceof DecimalFormat) {
                ((DecimalFormat)format).setParseBigDecimal(true);
            }
            return format.parse(numberStr);
        }
        catch (ParseException e) {
            NumberFormatException nfe = new NumberFormatException(e.getMessage());
            nfe.initCause(e);
            throw nfe;
        }
    }

    public static Integer parseInt(String numberStr, Integer defaultValue) {
        if (StringUtils.isEmpty(numberStr)) {
            return defaultValue;
        }
        try {
            return NumberUtils.parseInt(numberStr);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static Long parseLong(String numberStr, Long defaultValue) {
        if (StringUtils.isEmpty(numberStr)) {
            return defaultValue;
        }
        try {
            return NumberUtils.parseLong(numberStr);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static Float parseFloat(String numberStr, Float defaultValue) {
        if (StringUtils.isEmpty(numberStr)) {
            return defaultValue;
        }
        try {
            return Float.valueOf(NumberUtils.parseFloat(numberStr));
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static Double parseDouble(String numberStr, Double defaultValue) {
        if (StringUtils.isEmpty(numberStr)) {
            return defaultValue;
        }
        try {
            return NumberUtils.parseDouble(numberStr);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static Number parseNumber(String numberStr, Number defaultValue) {
        if (StringUtils.isEmpty(numberStr)) {
            return defaultValue;
        }
        try {
            return NumberUtils.parseNumber(numberStr);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }
}

