/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.common;

import cn.buli_home.utils.common.ObjectUtils;
import cn.buli_home.utils.common.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class MapUtils {
    public static boolean isEmpty(Map<?, ?> map) {
        return Objects.isNull(map) || map.isEmpty();
    }

    public static String getStringValue(Map<String, Object> map, String key) {
        if (map.containsKey(key)) {
            return StringUtils.convert2String(map.get(key));
        }
        return null;
    }

    public static Integer getIntegerValue(Map<String, Object> map, String key) {
        if (map.containsKey(key)) {
            return ObjectUtils.parseInt(map.get(key));
        }
        return null;
    }

    public static Long getLongValue(Map<String, Object> map, String key) {
        if (map.containsKey(key)) {
            return ObjectUtils.parseLong(map.get(key));
        }
        return null;
    }

    public static Double getDoubleValue(Map<String, Object> map, String key) {
        if (map.containsKey(key)) {
            return ObjectUtils.parseDouble(map.get(key));
        }
        return null;
    }

    public static Boolean getBooleanValue(Map<String, Object> map, String key) {
        if (map.containsKey(key)) {
            return ObjectUtils.parseBoolean(map.get(key));
        }
        return null;
    }

    public static Map<String, Object> model2Map(Object model, Class ... annotations) {
        if (model == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Field[] fields1 = model.getClass().getSuperclass().getDeclaredFields();
        Field[] fields2 = model.getClass().getDeclaredFields();
        ArrayList<Field> list = new ArrayList<Field>(Arrays.asList(fields1));
        List<Field> list2 = Arrays.asList(fields2);
        list.addAll(list2);
        block2: for (Field field : list) {
            String fieldName;
            boolean isStatic = Modifier.isStatic(field.getModifiers());
            if (isStatic || (fieldName = field.getName()).equals("gmtModified") || fieldName.equals("gmtCreate") || fieldName.equals("deleted") || fieldName.equals("create_time") || fieldName.equals("update_time") || fieldName.equals("valid")) continue;
            for (Class annotation : annotations) {
                Object ann = field.getAnnotation(annotation);
                if (null != ann) continue block2;
            }
            String getMethodName = MapUtils.p_getMethodName(fieldName);
            try {
                Method method = model.getClass().getMethod(getMethodName, new Class[0]);
                map.put(fieldName, method.invoke(model, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static List<Map<String, Object>> modelList2Map(List<?> list, Class ... annotations) {
        if (null == list) {
            return new ArrayList<Map<String, Object>>();
        }
        return list.stream().map(e -> MapUtils.model2Map(e, annotations)).collect(Collectors.toList());
    }

    public static Boolean checkValueBlank(Map<String, Object> map, String ... keys) {
        return MapUtils.checkValueBlank(map, false, keys);
    }

    public static Boolean checkValueBlank(Map<String, Object> map, Boolean isCheckBlank, String ... keys) {
        for (String key : keys) {
            boolean condition;
            Object obj = map.get(key);
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof String)) continue;
            String s = (String)obj;
            boolean bl = condition = isCheckBlank != false ? StringUtils.isEmptyWithoutBlank(s) : StringUtils.isEmpty(s);
            if (!condition) continue;
            return false;
        }
        return true;
    }

    private static String p_getMethodName(String name) {
        if (name != null && name.length() > 1) {
            return "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return name;
    }
}

