/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.common;

import cn.buli_home.utils.common.NumberUtils;
import cn.buli_home.utils.common.StringUtils;
import cn.buli_home.utils.common.Validator;
import cn.buli_home.utils.date.DateUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class IDCardUtils {
    private static final int CHINA_ID_MIN_LENGTH = 15;
    private static final int CHINA_ID_MAX_LENGTH = 18;
    private static final int[] POWER = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static final Map<String, String> CITY_CODES = new HashMap<String, String>();
    private static final Map<Character, Integer> TW_FIRST_CODE = new HashMap<Character, Integer>();

    public static String convert15To18(String idCard) {
        int sYear;
        if (idCard.length() != 15) {
            return "";
        }
        if (StringUtils.onlyRegex(idCard, "[0-9]*").booleanValue()) {
            String birthday = idCard.substring(6, 12);
            Date birthDate = DateUtils.parse(birthday, "yyMMdd");
            sYear = NumberUtils.parseInt(DateUtils.format(birthDate, "yyyy"));
            if (sYear > 2000) {
                sYear -= 100;
            }
        } else {
            return "";
        }
        StringBuilder idCard18 = new StringBuilder().append(idCard, 0, 6).append(sYear).append(idCard.substring(8));
        char sVal = IDCardUtils.p_getCheckCode18(idCard18.toString());
        idCard18.append(sVal);
        return idCard18.toString();
    }

    public static String convert18To15(String idCard) {
        if (!StringUtils.isEmpty(idCard) && IDCardUtils.isValidCard18(idCard)) {
            return idCard.substring(0, 6) + idCard.substring(8, idCard.length() - 1);
        }
        return idCard;
    }

    public static boolean isValidCard(String idCard) {
        if (StringUtils.isEmpty(idCard)) {
            return false;
        }
        int length = idCard.length();
        switch (length) {
            case 18: {
                return IDCardUtils.isValidCard18(idCard);
            }
            case 15: {
                return IDCardUtils.isValidCard15(idCard);
            }
            case 10: {
                String[] cardVal = IDCardUtils.isValidCard10(idCard);
                return null != cardVal && "true".equals(cardVal[2]);
            }
        }
        return false;
    }

    public static boolean isValidCard18(String idCard) {
        return IDCardUtils.isValidCard18(idCard, true);
    }

    public static boolean isValidCard18(String idCard, boolean ignoreCase) {
        if (idCard == null) {
            return false;
        }
        if (18 != idCard.length()) {
            return false;
        }
        String proCode = idCard.substring(0, 2);
        if (null == CITY_CODES.get(proCode)) {
            return false;
        }
        if (!Validator.isBirthday(idCard.substring(6, 14))) {
            return false;
        }
        String code17 = idCard.substring(0, 17);
        if (StringUtils.onlyRegex(code17, "[0-9]*").booleanValue()) {
            char val = IDCardUtils.p_getCheckCode18(code17);
            return ignoreCase ? Character.toLowerCase(val) == Character.toLowerCase(idCard.charAt(17)) : val == idCard.charAt(17);
        }
        return false;
    }

    public static boolean isValidCard15(String idCard) {
        if (idCard == null) {
            return false;
        }
        if (15 != idCard.length()) {
            return false;
        }
        if (StringUtils.onlyRegex(idCard, "[0-9]*").booleanValue()) {
            String proCode = idCard.substring(0, 2);
            if (null == CITY_CODES.get(proCode)) {
                return false;
            }
            return Validator.isBirthday("19" + idCard.substring(6, 12));
        }
        return false;
    }

    public static String[] isValidCard10(String idCard) {
        if (StringUtils.isEmpty(idCard)) {
            return null;
        }
        String[] info = new String[3];
        String card = idCard.replaceAll("[()]", "");
        if (card.length() != 8 && card.length() != 9 && idCard.length() != 10) {
            return null;
        }
        if (idCard.matches("^[a-zA-Z][0-9]{9}$")) {
            info[0] = "\u53f0\u6e7e";
            char char2 = idCard.charAt(1);
            if ('1' == char2) {
                info[1] = "M";
            } else if ('2' == char2) {
                info[1] = "F";
            } else {
                info[1] = "N";
                info[2] = "false";
                return info;
            }
            info[2] = IDCardUtils.isValidTWCard(idCard) ? "true" : "false";
        } else if (idCard.matches("^[157][0-9]{6}\\(?[0-9A-Z]\\)?$")) {
            info[0] = "\u6fb3\u95e8";
            info[1] = "N";
            info[2] = "true";
        } else if (idCard.matches("^[A-Z]{1,2}[0-9]{6}\\(?[0-9A]\\)?$")) {
            info[0] = "\u9999\u6e2f";
            info[1] = "N";
            info[2] = IDCardUtils.isValidHKCard(idCard) ? "true" : "false";
        } else {
            return null;
        }
        return info;
    }

    public static boolean isValidTWCard(String idCard) {
        if (null == idCard || idCard.length() != 10) {
            return false;
        }
        Integer iStart = TW_FIRST_CODE.get(Character.valueOf(idCard.charAt(0)));
        if (null == iStart) {
            return false;
        }
        int sum = iStart / 10 + iStart % 10 * 9;
        String mid = idCard.substring(1, 9);
        char[] chars = mid.toCharArray();
        int iFlag = 8;
        for (char c : chars) {
            sum += Integer.parseInt(String.valueOf(c)) * iFlag;
            --iFlag;
        }
        String end = idCard.substring(9, 10);
        return (sum % 10 == 0 ? 0 : 10 - sum % 10) == Integer.parseInt(end);
    }

    public static boolean isValidHKCard(String idCard) {
        int sum;
        String card = idCard.replaceAll("[()]", "");
        if (card.length() == 9) {
            sum = (Character.toUpperCase(card.charAt(0)) - 55) * 9 + (Character.toUpperCase(card.charAt(1)) - 55) * 8;
            card = card.substring(1, 9);
        } else {
            sum = 522 + (Character.toUpperCase(card.charAt(0)) - 55) * 8;
        }
        String mid = card.substring(1, 7);
        String end = card.substring(7, 8);
        char[] chars = mid.toCharArray();
        int iFlag = 7;
        for (char c : chars) {
            sum += Integer.parseInt(String.valueOf(c)) * iFlag;
            --iFlag;
        }
        sum = "A".equalsIgnoreCase(end) ? (sum += 10) : (sum += Integer.parseInt(end));
        return sum % 11 == 0;
    }

    public static String getBirthByIdCard(String idCard) {
        return IDCardUtils.getBirth(idCard);
    }

    public static String getBirth(String idCard) {
        if (StringUtils.isEmpty(idCard)) {
            return "";
        }
        int len = idCard.length();
        if (len < 15) {
            return "";
        }
        if (len == 15) {
            idCard = IDCardUtils.convert15To18(idCard);
        }
        return Objects.requireNonNull(idCard).substring(6, 14);
    }

    public static Date getBirthDate(String idCard) {
        String birthByIdCard = IDCardUtils.getBirthByIdCard(idCard);
        return StringUtils.isEmpty(birthByIdCard) ? null : DateUtils.parse(birthByIdCard, "yyyyMMdd");
    }

    public static DateUtils.DateNode getBirthDateNode(String idCard) {
        Date date = IDCardUtils.getBirthDate(idCard);
        return Objects.isNull(date) ? null : DateUtils.getDateNode(date);
    }

    public static int getAgeByIdCard(String idCard) {
        return IDCardUtils.getAgeByIdCard(idCard, new Date());
    }

    public static int getAgeByIdCard(String idCard, Date dateToCompare) {
        String birth = IDCardUtils.getBirthByIdCard(idCard);
        return DateUtils.age(DateUtils.parse(birth, "yyyyMMdd"), dateToCompare);
    }

    public static Short getYearByIdCard(String idCard) {
        int len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IDCardUtils.convert15To18(idCard);
        }
        return Short.valueOf(Objects.requireNonNull(idCard).substring(6, 10));
    }

    public static Short getMonthByIdCard(String idCard) {
        int len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IDCardUtils.convert15To18(idCard);
        }
        return Short.valueOf(Objects.requireNonNull(idCard).substring(10, 12));
    }

    public static Short getDayByIdCard(String idCard) {
        int len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IDCardUtils.convert15To18(idCard);
        }
        return Short.valueOf(Objects.requireNonNull(idCard).substring(12, 14));
    }

    public static int getGenderByIdCard(String idCard) {
        char sCardChar;
        if (StringUtils.isEmpty(idCard)) {
            return -1;
        }
        int len = idCard.length();
        if (len != 15 && len != 18) {
            return -1;
        }
        if (len == 15) {
            idCard = IDCardUtils.convert15To18(idCard);
        }
        return (sCardChar = Objects.requireNonNull(idCard).charAt(16)) % 2 != 0 ? 1 : 0;
    }

    public static String getProvinceCodeByIdCard(String idCard) {
        int len = idCard.length();
        if (len == 15 || len == 18) {
            return idCard.substring(0, 2);
        }
        return "";
    }

    public static String getProvinceByIdCard(String idCard) {
        String code = IDCardUtils.getProvinceCodeByIdCard(idCard);
        if (!StringUtils.isEmpty(code)) {
            return CITY_CODES.get(code);
        }
        return "";
    }

    public static String getCityCodeByIdCard(String idCard) {
        int len = idCard.length();
        if (len == 15 || len == 18) {
            return idCard.substring(0, 4);
        }
        return "";
    }

    public static String getDistrictCodeByIdCard(String idCard) {
        int len = idCard.length();
        if (len == 15 || len == 18) {
            return idCard.substring(0, 6);
        }
        return "";
    }

    public static String hide(String idCard, int startInclude, int endExclude) {
        return StringUtils.hide(idCard, startInclude, endExclude);
    }

    public static IDCard getIDCardInfo(String idCard) {
        return new IDCard(idCard);
    }

    private static char p_getCheckCode18(String code17) {
        int sum = IDCardUtils.p_getPowerSum(code17.toCharArray());
        return IDCardUtils.p_getCheckCode18(sum);
    }

    private static char p_getCheckCode18(int iSum) {
        switch (iSum % 11) {
            case 10: {
                return '2';
            }
            case 9: {
                return '3';
            }
            case 8: {
                return '4';
            }
            case 7: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 5: {
                return '7';
            }
            case 4: {
                return '8';
            }
            case 3: {
                return '9';
            }
            case 2: {
                return 'X';
            }
            case 1: {
                return '0';
            }
            case 0: {
                return '1';
            }
        }
        return ' ';
    }

    private static int p_getPowerSum(char[] iArr) {
        int iSum = 0;
        if (POWER.length == iArr.length) {
            for (int i = 0; i < iArr.length; ++i) {
                iSum += Integer.parseInt(String.valueOf(iArr[i])) * POWER[i];
            }
        }
        return iSum;
    }

    static {
        CITY_CODES.put("11", "\u5317\u4eac");
        CITY_CODES.put("12", "\u5929\u6d25");
        CITY_CODES.put("13", "\u6cb3\u5317");
        CITY_CODES.put("14", "\u5c71\u897f");
        CITY_CODES.put("15", "\u5185\u8499\u53e4");
        CITY_CODES.put("21", "\u8fbd\u5b81");
        CITY_CODES.put("22", "\u5409\u6797");
        CITY_CODES.put("23", "\u9ed1\u9f99\u6c5f");
        CITY_CODES.put("31", "\u4e0a\u6d77");
        CITY_CODES.put("32", "\u6c5f\u82cf");
        CITY_CODES.put("33", "\u6d59\u6c5f");
        CITY_CODES.put("34", "\u5b89\u5fbd");
        CITY_CODES.put("35", "\u798f\u5efa");
        CITY_CODES.put("36", "\u6c5f\u897f");
        CITY_CODES.put("37", "\u5c71\u4e1c");
        CITY_CODES.put("41", "\u6cb3\u5357");
        CITY_CODES.put("42", "\u6e56\u5317");
        CITY_CODES.put("43", "\u6e56\u5357");
        CITY_CODES.put("44", "\u5e7f\u4e1c");
        CITY_CODES.put("45", "\u5e7f\u897f");
        CITY_CODES.put("46", "\u6d77\u5357");
        CITY_CODES.put("50", "\u91cd\u5e86");
        CITY_CODES.put("51", "\u56db\u5ddd");
        CITY_CODES.put("52", "\u8d35\u5dde");
        CITY_CODES.put("53", "\u4e91\u5357");
        CITY_CODES.put("54", "\u897f\u85cf");
        CITY_CODES.put("61", "\u9655\u897f");
        CITY_CODES.put("62", "\u7518\u8083");
        CITY_CODES.put("63", "\u9752\u6d77");
        CITY_CODES.put("64", "\u5b81\u590f");
        CITY_CODES.put("65", "\u65b0\u7586");
        CITY_CODES.put("71", "\u53f0\u6e7e");
        CITY_CODES.put("81", "\u9999\u6e2f");
        CITY_CODES.put("82", "\u6fb3\u95e8");
        CITY_CODES.put("83", "\u53f0\u6e7e");
        CITY_CODES.put("91", "\u56fd\u5916");
        TW_FIRST_CODE.put(Character.valueOf('A'), 10);
        TW_FIRST_CODE.put(Character.valueOf('B'), 11);
        TW_FIRST_CODE.put(Character.valueOf('C'), 12);
        TW_FIRST_CODE.put(Character.valueOf('D'), 13);
        TW_FIRST_CODE.put(Character.valueOf('E'), 14);
        TW_FIRST_CODE.put(Character.valueOf('F'), 15);
        TW_FIRST_CODE.put(Character.valueOf('G'), 16);
        TW_FIRST_CODE.put(Character.valueOf('H'), 17);
        TW_FIRST_CODE.put(Character.valueOf('J'), 18);
        TW_FIRST_CODE.put(Character.valueOf('K'), 19);
        TW_FIRST_CODE.put(Character.valueOf('L'), 20);
        TW_FIRST_CODE.put(Character.valueOf('M'), 21);
        TW_FIRST_CODE.put(Character.valueOf('N'), 22);
        TW_FIRST_CODE.put(Character.valueOf('P'), 23);
        TW_FIRST_CODE.put(Character.valueOf('Q'), 24);
        TW_FIRST_CODE.put(Character.valueOf('R'), 25);
        TW_FIRST_CODE.put(Character.valueOf('S'), 26);
        TW_FIRST_CODE.put(Character.valueOf('T'), 27);
        TW_FIRST_CODE.put(Character.valueOf('U'), 28);
        TW_FIRST_CODE.put(Character.valueOf('V'), 29);
        TW_FIRST_CODE.put(Character.valueOf('X'), 30);
        TW_FIRST_CODE.put(Character.valueOf('Y'), 31);
        TW_FIRST_CODE.put(Character.valueOf('W'), 32);
        TW_FIRST_CODE.put(Character.valueOf('Z'), 33);
        TW_FIRST_CODE.put(Character.valueOf('I'), 34);
        TW_FIRST_CODE.put(Character.valueOf('O'), 35);
    }

    public static class IDCard
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String provinceCode;
        private final String cityCode;
        private final DateUtils.DateNode birthDate;
        private final Integer gender;
        private final int age;

        public IDCard(String idCard) {
            this.provinceCode = IDCardUtils.getProvinceCodeByIdCard(idCard);
            this.cityCode = IDCardUtils.getCityCodeByIdCard(idCard);
            this.birthDate = IDCardUtils.getBirthDateNode(idCard);
            this.gender = IDCardUtils.getGenderByIdCard(idCard);
            this.age = IDCardUtils.getAgeByIdCard(idCard);
        }

        public String getProvinceCode() {
            return this.provinceCode;
        }

        public String getCityCode() {
            return this.cityCode;
        }

        public DateUtils.DateNode getBirthDate() {
            return this.birthDate;
        }

        public Integer getGender() {
            return this.gender;
        }

        public int getAge() {
            return this.age;
        }
    }
}

