/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.common;

import cn.buli_home.utils.common.BasicArrayUtils;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;

public class ArrayUtils
extends BasicArrayUtils {
    public static <T> boolean isEmpty(T[] array) {
        return Objects.isNull(array) || array.length == 0;
    }

    public static <T> T[] defaultIfEmpty(T[] array, T[] defaultArray) {
        return ArrayUtils.isEmpty(array) ? defaultArray : array;
    }

    public static boolean isEmpty(Object array) {
        if (Objects.nonNull(array)) {
            if (ArrayUtils.isArray(array)) {
                return 0 == Array.getLength(array);
            }
            return false;
        }
        return true;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return Objects.nonNull(array) && array.length != 0;
    }

    public static boolean isNotEmpty(Object array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static <T> boolean hasNull(T ... array) {
        if (ArrayUtils.isNotEmpty(array)) {
            for (T element : array) {
                if (!Objects.isNull(element)) continue;
                return true;
            }
        }
        return Objects.isNull(array);
    }

    public static boolean isArray(Object obj) {
        return Objects.nonNull(obj) && obj.getClass().isArray();
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (ArrayUtils.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj.toString();
    }
}

