/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.file;

import cn.buli_home.utils.common.StringUtils;
import cn.buli_home.utils.file.FileConstant;
import cn.buli_home.utils.file.FileUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserDefaultUtils {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final String UD_FILE_NAME = "UserDefault.txt";
    private String UD_FILE_PATH = FileConstant.USER_DEFAULT_PATH;
    private String PATH = this.UD_FILE_PATH + "UserDefault.txt";
    private static volatile UserDefaultUtils INSTANCE = null;

    public static void recordString(String key, String value) throws Exception {
        UserDefaultUtils.getInstance().p_recordString(key, value);
    }

    public static void record(Map<String, String> map) throws Exception {
        UserDefaultUtils.getInstance().p_record(map);
    }

    public static String loadRecordString(String key) throws Exception {
        return UserDefaultUtils.getInstance().p_loadRecordString(key);
    }

    public static void setFilePath(String filePath) {
        UserDefaultUtils.getInstance().p_setFilePath(filePath);
    }

    public static void clean(String key) {
        UserDefaultUtils.getInstance().p_clean(key);
    }

    public static void cleanAll() {
        UserDefaultUtils.getInstance().p_cleanAll();
    }

    private void p_recordString(String key, String value) throws Exception {
        if (Objects.isNull(key)) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        UserDefaultUtils.record(map);
    }

    private void p_record(Map<String, String> map) throws Exception {
        if (Objects.isNull(map)) {
            return;
        }
        String content = FileUtils.readFile(this.PATH);
        JSONObject jsonObject = JSON.parseObject((String)content);
        if (Objects.isNull(jsonObject)) {
            jsonObject = new JSONObject();
        }
        map.forEach((arg_0, arg_1) -> jsonObject.put(arg_0, arg_1));
        FileUtils.writeFile(this.PATH, jsonObject.toJSONString(new JSONWriter.Feature[0]), true);
    }

    private String p_loadRecordString(String key) throws Exception {
        if (Objects.isNull(key)) {
            return "";
        }
        String content = FileUtils.readFile(this.PATH);
        JSONObject jsonObject = JSON.parseObject((String)content);
        return null == jsonObject ? "" : jsonObject.getString(key);
    }

    private void p_setFilePath(String filePath) {
        if (StringUtils.isEmpty(filePath)) {
            return;
        }
        this.UD_FILE_PATH = filePath;
        this.PATH = !filePath.endsWith("\\") && !filePath.endsWith("/") ? this.UD_FILE_PATH + File.separator + "UserDefault.txt" : this.UD_FILE_PATH + "UserDefault.txt";
    }

    private void p_clean(String key) {
        try {
            UserDefaultUtils.recordString(key, "");
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
    }

    private void p_cleanAll() {
        try {
            FileUtils.writeFile(this.PATH, "", true);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
    }

    private UserDefaultUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static UserDefaultUtils getInstance() {
        if (null != INSTANCE) return INSTANCE;
        Class<UserDefaultUtils> clazz = UserDefaultUtils.class;
        synchronized (UserDefaultUtils.class) {
            if (null != INSTANCE) return INSTANCE;
            INSTANCE = new UserDefaultUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }
}

